/*
 * Decompiled with CFR 0.152.
 */
package deathtags.commands;

import deathtags.core.ConfigHandler;
import deathtags.core.MMOParties;
import deathtags.core.events.EventClient;
import deathtags.gui.HealthBar;
import deathtags.helpers.ArrayHelpers;
import deathtags.helpers.CommandMessageHelper;
import deathtags.networking.MessageOpenUI;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PartyCommand
extends CommandBase {
    public String[] corrections = new String[]{"invite", "accept", "deny", "kick", "leave", "leader", "tp", "disband", "gui"};

    public String func_71517_b() {
        return "party";
    }

    public String func_71518_a(ICommandSender sender) {
        return "party <action> (player)";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        List<String> completions = new ArrayList<String>();
        if (args.length < 2) {
            if (args.length == 0) {
                if (ConfigHandler.Debug_Options.debuggingEnabled) {
                    completions.add("debug");
                }
                for (int i = 0; i < this.corrections.length; ++i) {
                    completions.add(this.corrections[i]);
                }
            } else {
                completions = ArrayHelpers.FindClosestToValue(args[0], this.corrections);
            }
        }
        if (args.length == 2 || args.length == 1 && (args[0] == "invite" || args[0] == "kick" || args[0] == "leader")) {
            for (String player : server.func_71213_z()) {
                if (sender.func_70005_c_() == player) continue;
                completions.add(player);
            }
        }
        return completions;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        EntityPlayerMP player = (EntityPlayerMP)sender.func_174793_f();
        EntityPlayerMP target = null;
        if (args.length == 0) {
            CommandMessageHelper.SendInfo((EntityPlayer)player, String.format("Command must contain valid argument(s). Valid arguments are: %s", String.join((CharSequence)", ", Arrays.asList(this.corrections))), new String[0]);
            return;
        }
        if (args.length > 1) {
            target = server.func_184103_al().func_152612_a(args.length == 3 ? args[2] : args[1]);
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        PlayerStats stats = MMOParties.GetStatsByName(player.func_70005_c_());
        switch (args[0]) {
            case "tp": {
                if (!ConfigHandler.Server_Options.allowPartyTP) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "rpgparties.message.error.teleport.server", new String[0]);
                    return;
                }
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "rpgparties.message.error.teleport.party", new String[0]);
                    return;
                }
                stats.party.Teleport((EntityPlayer)player, (EntityPlayer)target);
                break;
            }
            case "kick": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "rpgparties.message.error.party", new String[0]);
                    return;
                }
                stats.party.Leave((EntityPlayer)target);
                break;
            }
            case "create": {
                Party.Create((EntityPlayer)player);
                break;
            }
            case "invite": {
                if (target == null) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "rpgparties.message.error.argument", player.func_70005_c_());
                    return;
                }
                if (!stats.InParty()) {
                    Party.Create((EntityPlayer)player);
                }
                stats.party.Invite((EntityPlayer)player, (EntityPlayer)target);
                break;
            }
            case "accept": {
                if (stats.partyInvite == null) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "rpgparties.message.error.invite", new String[0]);
                    return;
                }
                stats.partyInvite.Join((EntityPlayer)player, true);
                break;
            }
            case "deny": {
                if (stats.partyInvite == null) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "rpgparties.message.error.invite", new String[0]);
                    return;
                }
                stats.partyInvite = null;
                CommandMessageHelper.SendInfo((EntityPlayer)player, "rpgparties.message.party.deny", new String[0]);
                break;
            }
            case "leave": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "rpgparties.message.error.party", new String[0]);
                    return;
                }
                stats.party.Leave((EntityPlayer)player);
                stats.party = null;
                break;
            }
            case "leader": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "You are not currently in a party.", new String[0]);
                    return;
                }
                if (stats.party.leader != player) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "Only the leader may promote members.", new String[0]);
                    return;
                }
                if (target == null) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "rpgparties.message.error.argument", player.func_70005_c_());
                    return;
                }
                stats.party.MakeLeader((EntityPlayer)player);
                break;
            }
            case "disband": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "rpgparties.message.error.party", new String[0]);
                    return;
                }
                if (stats.party.leader != player) {
                    CommandMessageHelper.SendError((EntityPlayer)player, "rpgparties.message.error.disband", new String[0]);
                    return;
                }
                stats.party.Disband();
                break;
            }
            case "gui": {
                if (player.field_70170_p.field_72995_K) {
                    MMOParties.network.sendTo((IMessage)new MessageOpenUI(), player);
                    break;
                }
                if (!Minecraft.func_71410_x().func_71356_B()) break;
                EventClient.openScreen();
                break;
            }
            case "debug": {
                if (!ConfigHandler.Debug_Options.debuggingEnabled) {
                    return;
                }
                HealthBar.DISPLAY_SELF = true;
                CommandMessageHelper.SendInfo((EntityPlayer)player, MMOParties.DEBUGGING_ENABLED ? "Debug Mode has been enabled" : "Debug Mode has been disabled.", new String[0]);
                break;
            }
        }
    }
}

