/*
 * Decompiled with CFR 0.152.
 */
package deathtags.core;

import deathtags.commands.PartyCommand;
import deathtags.core.events.EventClient;
import deathtags.core.events.EventCommon;
import deathtags.gui.HealthBar;
import deathtags.networking.MessageGUIInvitePlayer;
import deathtags.networking.MessageSendMemberData;
import deathtags.networking.MessageUpdateParty;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="mmoparties", version="2.3.0", name="RPG Parties", acceptedMinecraftVersions="[1.12.2]")
public class MMOParties {
    public static final String MODID = "mmoparties";
    public static final String VERSION = "2.3.0";
    public static final String NAME = "RPG Parties";
    public static SimpleNetworkWrapper network;
    public static Party localParty;
    public static Map<EntityPlayer, PlayerStats> PlayerStats;
    public static KeyBinding OPEN_GUI_KEY;
    public static boolean DEBUGGING_ENABLED;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        System.out.println("mmoparties is pre-loading!");
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        System.out.println("mmoparties is loading!");
        network.registerMessage(MessageUpdateParty.Handler.class, MessageUpdateParty.class, 0, Side.CLIENT);
        network.registerMessage(MessageSendMemberData.Handler.class, MessageSendMemberData.class, 1, Side.CLIENT);
        network.registerMessage(MessageGUIInvitePlayer.Handler.class, MessageGUIInvitePlayer.class, 2, Side.CLIENT);
        network.registerMessage(MessageUpdateParty.Handler.class, MessageUpdateParty.class, 0, Side.SERVER);
        network.registerMessage(MessageSendMemberData.Handler.class, MessageSendMemberData.class, 1, Side.SERVER);
        network.registerMessage(MessageGUIInvitePlayer.Handler.class, MessageGUIInvitePlayer.class, 2, Side.SERVER);
        if (event.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new EventClient());
            this.clientSetup();
        }
        MinecraftForge.EVENT_BUS.register((Object)new EventCommon());
    }

    public void clientSetup() {
        OPEN_GUI_KEY = new KeyBinding("key.opengui.desc", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, 25, "key.mmoparties.category");
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_GUI_KEY);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        System.out.println("mmoparties is post-loading!");
        if (event.getSide() == Side.CLIENT) {
            HealthBar.init();
        }
    }

    @Mod.EventHandler
    public static void serverStarting(FMLServerStartingEvent event) {
        System.out.println("Registering commands");
        event.registerServerCommand((ICommand)new PartyCommand());
    }

    public static PlayerStats GetStatsByName(String name) {
        for (Map.Entry<EntityPlayer, PlayerStats> plr : PlayerStats.entrySet()) {
            if (plr.getKey().func_70005_c_() != name) continue;
            return plr.getValue();
        }
        return null;
    }

    public static PlayerStats GetStats(EntityPlayer player) {
        return MMOParties.GetStatsByName(player.func_70005_c_());
    }

    static {
        PlayerStats = new HashMap<EntityPlayer, PlayerStats>();
        DEBUGGING_ENABLED = false;
    }
}

