/*
 * Decompiled with CFR 0.152.
 */
package deathtags.core.events;

import deathtags.api.PartyHelper;
import deathtags.api.relation.EnumRelation;
import deathtags.core.ConfigHandler;
import deathtags.core.MMOParties;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class EventCommon {
    public static Party globalParty = null;

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (!MMOParties.PlayerStats.containsKey(player)) {
            MMOParties.PlayerStats.put(player, new PlayerStats(player));
        }
        event.player.func_184102_h().func_184103_al().func_181057_v().forEach(serverEntityPlayer -> {
            PlayerStats ply = MMOParties.GetStats((EntityPlayer)serverEntityPlayer);
            if (ply.InParty() && !MMOParties.GetStats(player).InParty() && ply.party.IsMemberOffline(player)) {
                ply.party.Join(player, false);
                return;
            }
        });
        if (!ConfigHandler.Server_Options.autoAssignParties) {
            return;
        }
        if (globalParty == null) {
            globalParty = Party.CreateGlobalParty(player);
        } else if (!globalParty.IsMember(player)) {
            globalParty.Join(event.player, true);
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerStats playerStats = MMOParties.GetStatsByName(event.player.func_70005_c_());
        if (playerStats.InParty()) {
            playerStats.party.players.remove(event.player);
            if (playerStats.party.players.size() > 0) {
                playerStats.party.MakeLeader(playerStats.party.players.get(0));
            }
        }
        MMOParties.PlayerStats.remove(event.player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void OnPlayerHurt(LivingHurtEvent event) {
        EntityPlayer source;
        if (!ConfigHandler.Server_Options.friendlyFireDisabled) {
            return;
        }
        if (!event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityPlayer) || !(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (PartyHelper.Server.GetRelation((EntityPlayerMP)player, (EntityPlayerMP)(source = (EntityPlayer)event.getSource().func_76346_g())) == EnumRelation.PARTY) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void OnPlayerMove(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.player;
        PlayerStats stats = MMOParties.GetStatsByName(player.func_70005_c_());
        if (stats == null) {
            return;
        }
        stats.TickTeleport();
        if (stats.party != null) {
            MMOParties.PlayerStats.get((Object)player).party.SendPartyMemberData(player, false);
        }
    }
}

