/*
 * Decompiled with CFR 0.152.
 */
package deathtags.gui;

import deathtags.core.ConfigHandler;
import deathtags.core.MMOParties;
import deathtags.gui.UISpec;
import deathtags.stats.PartyMemberData;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class HealthBar
extends Gui {
    public static final ResourceLocation TEXTURE_ICON = new ResourceLocation("mmoparties", "textures/icons.png");
    public static final ResourceLocation HEART_TEXTURE = new ResourceLocation("minecraft", "textures/gui/icons.png");
    private static Minecraft mc;
    private static int updateCounter;
    private static Random random;
    public static boolean DISPLAY_SELF;
    public static NuggetBar[] nuggetBars;

    public HealthBar(Minecraft mc) {
        HealthBar.mc = mc;
        random = new Random();
    }

    public static int Draw(float current, float max, UISpec UI, int backgroundOffset, int halfOffset, boolean compact, boolean render) {
        if (!render) {
            return -1;
        }
        if (!compact) {
            return HealthBar.DrawNuggetBar(current, max, UI, backgroundOffset, halfOffset);
        }
        return HealthBar.DrawNuggetBarCompact(current, max, UI, backgroundOffset);
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        int lastOffset = 10;
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        if (MMOParties.localParty != null && MMOParties.localParty.local_players.size() >= 1) {
            int pN = 0;
            for (PartyMemberData data : MMOParties.localParty.data.values()) {
                if (data.name.equals(HealthBar.mc.field_71439_g.func_70005_c_()) && !DISPLAY_SELF) continue;
                lastOffset += this.RenderMember(data, lastOffset, pN, MMOParties.localParty.local_players.size() > 4 || ConfigHandler.Client_Options.useSimpleUI);
                ++pN;
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    public static int DrawNuggetBarCompact(float current, float max, UISpec UI, int backgroundOffset) {
        int left = UI.x;
        int top = UI.y;
        int startX = left;
        int startY = top;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(UI.texture);
        Minecraft.func_71410_x().field_71456_v.func_73729_b(startX, startY, backgroundOffset, UI.texture_y, 9, 9);
        Minecraft.func_71410_x().field_71456_v.func_73729_b(startX, startY, UI.texture_x, UI.texture_y, 9, 9);
        HealthBar.mc.field_71466_p.func_78276_b(String.format("%s", Math.floor(current)), startX + 12, startY, 0xFFFFFF);
        return 6;
    }

    int RenderMember(PartyMemberData data, int lastOffset, int pN, boolean compact) {
        if (data == null) {
            return 0;
        }
        int iconRows = 0;
        int additionalOffset = 0;
        int posX = 4;
        int defaultOffset = ConfigHandler.Client_Options.uiYOffset;
        int yOffset = 15 * (pN + 1) + lastOffset;
        if (compact) {
            yOffset = (int)((double)yOffset / 1.7) + 4;
            nuggetBars[0].Render(data, posX + 30, defaultOffset - 10 + yOffset, true);
        } else {
            for (NuggetBar bar : nuggetBars) {
                int offset = bar.Render(data, posX, defaultOffset + 12 * iconRows + yOffset, false);
                additionalOffset += offset;
                if (offset == -1) continue;
                ++iconRows;
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_ICON);
        if (data.leader) {
            Minecraft.func_71410_x().field_71456_v.func_73729_b(10, defaultOffset - 20 + yOffset, 0, 18, 9, 9);
        }
        HealthBar.mc.field_71466_p.func_78276_b(data.name, 10, defaultOffset - 10 + yOffset, 0xFFFFFF);
        return additionalOffset;
    }

    public static int DrawNuggetBar(float current, float max, UISpec UI, int backgroundOffset, int halfOffset) {
        UI.x /= 2;
        int length = 0;
        int bars = 0;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(UI.texture);
        int i = 0;
        while ((float)i < max / 2.0f) {
            int dropletHalf = i * 2 + 1;
            int nuggetX = UI.x + length * 8 + 9;
            int offsetY = UI.y;
            if (max > 6.0f && current <= 6.0f && (float)updateCounter % (current * 3.0f + 1.0f) == 0.0f) {
                offsetY = UI.y + (random.nextInt(3) - 1);
            }
            Minecraft.func_71410_x().field_71456_v.func_73729_b(nuggetX, offsetY + 4 * bars, backgroundOffset, UI.texture_y, 9, 9);
            if ((int)current > dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.func_73729_b(nuggetX, offsetY + 4 * bars, UI.texture_x, UI.texture_y, 9, 9);
            } else if ((int)current == dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.func_73729_b(nuggetX, offsetY + 4 * bars, UI.texture_x + halfOffset, UI.texture_y, 9, 9);
            }
            if (++length > 9) {
                ++bars;
                length = 0;
            }
            ++i;
        }
        return 6 * (bars + 1);
    }

    public static void init() {
        System.out.println("Load GUI");
        MinecraftForge.EVENT_BUS.register((Object)new HealthBar(Minecraft.func_71410_x()));
    }

    static {
        updateCounter = 0;
        DISPLAY_SELF = false;
        nuggetBars = new NuggetBar[]{(data, xOffset, yOffset, compact) -> HealthBar.Draw(data.health, data.maxHealth, new UISpec(HEART_TEXTURE, xOffset, yOffset, 52, 0), 16, 9, compact, true), (data, xOffset, yOffset, compact) -> HealthBar.Draw(data.hunger, 20.0f, new UISpec(HEART_TEXTURE, xOffset, yOffset, 52, 27), 16, 9, compact, ConfigHandler.Client_Options.showHunger), (data, xOffset, yOffset, compact) -> HealthBar.Draw(data.armor, data.armor, new UISpec(HEART_TEXTURE, xOffset, yOffset, 34, 9), 16, -9, compact, ConfigHandler.Client_Options.showArmor), (data, xOffset, yOffset, compact) -> HealthBar.Draw(data.absorption, data.absorption, new UISpec(HEART_TEXTURE, xOffset, yOffset, 160, 0), 16, 9, compact, ConfigHandler.Client_Options.showAbsorption)};
    }

    public static interface NuggetBar {
        public int Render(PartyMemberData var1, int var2, int var3, boolean var4);
    }
}

