/*
 * Decompiled with CFR 0.152.
 */
package deathtags.gui.screens;

import deathtags.core.MMOParties;
import deathtags.gui.screens.Button;
import deathtags.gui.screens.IPressable;
import deathtags.networking.EnumPartyGUIAction;
import deathtags.networking.MessageGUIInvitePlayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PartyScreen
extends GuiScreen {
    private EnumPartyGUIAction menu;
    private List<Button> buttons = new ArrayList<Button>();

    public PartyScreen() {
        this.menu = MMOParties.localParty == null ? EnumPartyGUIAction.INVITE : EnumPartyGUIAction.KICK;
    }

    public PartyScreen(EnumPartyGUIAction action) {
        this.menu = action;
    }

    protected void func_146284_a(GuiButton button) {
        if (this.buttons.get(button.field_146127_k) != null) {
            System.out.println("Id: " + button.field_146127_k);
            this.buttons.get(button.field_146127_k).OnPress();
        }
    }

    private GuiButton CreateButton(String text, int buttonNumber, IPressable pressable) {
        int buttonY = 24 * buttonNumber + 20;
        Button button = new Button(this.buttons.size(), (this.field_146294_l - 200) / 2, buttonY, 200, 80, new TextComponentTranslation(text, new Object[0]).func_150254_d(), pressable);
        this.buttons.add(button);
        if (this.menu == EnumPartyGUIAction.INVITE) {
            buttonY = 26 * this.field_146292_n.size() + 40;
        }
        return new GuiButton(button.field_146127_k, (this.field_146294_l - 200) / 2, buttonY, 200, 20, new TextComponentTranslation(text, new Object[0]).func_150254_d());
    }

    private GuiButton CreateSubButton(String text, int xOffset, int buttonNumber, IPressable pressable) {
        int buttonY = 24 * buttonNumber + 20;
        Button button = new Button(this.buttons.size(), (this.field_146294_l + 200) / 2 + xOffset, buttonY, 20, 20, new TextComponentTranslation(text, new Object[0]).func_150254_d(), pressable);
        this.buttons.add(button);
        if (this.menu == EnumPartyGUIAction.INVITE) {
            buttonY = 26 * this.field_146292_n.size() + 20;
        }
        return button;
    }

    private String[] GetApplicablePlayers() {
        ArrayList playerList = new ArrayList();
        if (Minecraft.func_71410_x().func_71387_A()) {
            Minecraft.func_71410_x().func_71401_C().func_184103_al().func_181057_v().forEach(player -> playerList.add(player.func_145748_c_().func_150260_c()));
        } else {
            if (Minecraft.func_71410_x().func_147114_u() == null) {
                return new String[0];
            }
            Minecraft.func_71410_x().func_147114_u().func_175106_d().forEach(player -> playerList.add(player.func_178845_a().getName()));
        }
        return playerList.toArray(new String[0]);
    }

    private void DisplayMemberList() {
        int buttonNumber = 1;
        this.func_189646_b(this.CreateButton("rpgparties.gui.invite", buttonNumber++, () -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new PartyScreen(EnumPartyGUIAction.INVITE))));
        MMOParties.localParty.local_players.forEach(player -> {
            int height = 26 * (2 + MMOParties.localParty.local_players.indexOf(player));
            GuiButton widget = this.func_189646_b(this.CreateButton((String)player, 2 + MMOParties.localParty.local_players.indexOf(player), () -> {}));
            widget.field_146124_l = false;
            if (!MMOParties.localParty.data.get((Object)Minecraft.func_71410_x().field_71439_g.func_70005_c_()).leader || !MMOParties.localParty.data.get((Object)player).leader) {
                return;
            }
            this.func_189646_b(this.CreateSubButton("K", 20, height, () -> MMOParties.network.sendToServer((IMessage)new MessageGUIInvitePlayer((CharSequence)player, EnumPartyGUIAction.KICK))));
            this.func_189646_b(this.CreateSubButton("L", 40, height, () -> MMOParties.network.sendToServer((IMessage)new MessageGUIInvitePlayer((CharSequence)player, EnumPartyGUIAction.LEADER))));
        });
        this.func_189646_b(this.CreateButton("rpgparties.gui.leave", 1 + MMOParties.localParty.local_players.size(), () -> {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new PartyScreen(EnumPartyGUIAction.INVITE));
            MMOParties.network.sendToServer((IMessage)new MessageGUIInvitePlayer("", EnumPartyGUIAction.LEAVE));
        }));
        if (!MMOParties.localParty.data.get((Object)Minecraft.func_71410_x().field_71439_g.func_70005_c_()).leader) {
            return;
        }
        this.func_189646_b(this.CreateButton("rpgparties.gui.disband", 2 + MMOParties.localParty.local_players.size(), () -> {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new PartyScreen(EnumPartyGUIAction.INVITE));
            MMOParties.network.sendToServer((IMessage)new MessageGUIInvitePlayer("", EnumPartyGUIAction.DISBAND));
        }));
    }

    public void func_73866_w_() {
        switch (this.menu) {
            case NONE: {
                break;
            }
            case INVITE: {
                for (String player : this.GetApplicablePlayers()) {
                    if (player == Minecraft.func_71410_x().field_71439_g.func_70005_c_()) continue;
                    this.func_189646_b(this.CreateButton(player, 8 + this.buttons.size(), () -> MMOParties.network.sendToServer((IMessage)new MessageGUIInvitePlayer(player, EnumPartyGUIAction.INVITE))));
                }
                break;
            }
            case KICK: {
                this.DisplayMemberList();
            }
        }
    }

    public void func_73863_a(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        super.func_73863_a(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        this.func_73732_a(this.field_146289_q, this.menu == EnumPartyGUIAction.INVITE ? new TextComponentTranslation("rpgparties.gui.title.invite", new Object[0]).func_150254_d() : new TextComponentTranslation("rpgparties.gui.title", new Object[0]).func_150254_d(), this.field_146294_l / 2, 14, 0xFFFFFF);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }
}

