/*
 * Decompiled with CFR 0.152.
 */
package deathtags.networking;

import com.google.common.base.Charsets;
import deathtags.core.MMOParties;
import deathtags.networking.EnumPartyGUIAction;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageGUIInvitePlayer
implements IMessage {
    public String name;
    public EnumPartyGUIAction action;

    public MessageGUIInvitePlayer() {
    }

    public MessageGUIInvitePlayer(CharSequence charSequence, EnumPartyGUIAction action) {
        this.name = charSequence.toString();
        this.action = action;
    }

    public void fromBytes(ByteBuf buf) {
        this.name = buf.readCharSequence(buf.readInt(), Charsets.UTF_8).toString();
        this.action = EnumPartyGUIAction.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.name.length());
        buf.writeCharSequence((CharSequence)this.name, Charsets.UTF_8);
        buf.writeInt(this.action.ordinal());
    }

    public static class Handler
    implements IMessageHandler<MessageGUIInvitePlayer, IMessage> {
        public IMessage onMessage(MessageGUIInvitePlayer pkt, MessageContext messageContext) {
            PlayerStats stats = MMOParties.GetStatsByName(messageContext.getServerHandler().field_147369_b.func_70005_c_());
            switch (pkt.action) {
                case INVITE: {
                    if (!stats.InParty()) {
                        stats.party = new Party((EntityPlayer)messageContext.getServerHandler().field_147369_b);
                    }
                    stats.party.Invite((EntityPlayer)messageContext.getServerHandler().field_147369_b, messageContext.getServerHandler().field_147369_b.field_70170_p.func_72924_a(pkt.name));
                    break;
                }
                case KICK: {
                    if (!stats.InParty()) {
                        return null;
                    }
                    stats.party.Leave(messageContext.getServerHandler().field_147369_b.field_70170_p.func_72924_a(pkt.name));
                    break;
                }
                case LEADER: {
                    if (!stats.InParty()) {
                        return null;
                    }
                    stats.party.MakeLeader(messageContext.getServerHandler().field_147369_b.field_70170_p.func_72924_a(pkt.name));
                    break;
                }
                case DISBAND: {
                    if (!stats.InParty()) {
                        return null;
                    }
                    stats.party.Disband();
                    break;
                }
                case LEAVE: {
                    if (!stats.InParty()) {
                        return null;
                    }
                    stats.Leave();
                }
            }
            return null;
        }
    }
}

