/*
 * Decompiled with CFR 0.152.
 */
package deathtags.networking;

import com.google.common.base.Charsets;
import deathtags.core.MMOParties;
import deathtags.networking.PartyPacketDataBuilder;
import deathtags.stats.Party;
import deathtags.stats.PartyMemberData;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageSendMemberData
implements IMessage {
    private PartyPacketDataBuilder builder;

    public MessageSendMemberData() {
    }

    public MessageSendMemberData(PartyPacketDataBuilder data) {
        this.builder = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.builder = new PartyPacketDataBuilder().SetPlayer(buf.readCharSequence(buf.readInt(), Charsets.UTF_8).toString()).SetHealth(buf.readFloat()).SetMaxHealth(buf.readFloat()).SetArmor(buf.readFloat()).SetLeader(buf.readBoolean()).SetAbsorption(buf.readFloat()).SetShields(buf.readFloat()).SetMaxShields(buf.readFloat()).SetHunger(buf.readFloat());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.builder.nameLength);
        buf.writeBytes(this.builder.playerId.getBytes());
        buf.writeFloat(this.builder.health);
        buf.writeFloat(this.builder.maxHealth);
        buf.writeFloat(this.builder.armor);
        buf.writeBoolean(this.builder.leader);
        buf.writeFloat(this.builder.absorption);
        buf.writeFloat(this.builder.shields);
        buf.writeFloat(this.builder.maxShields);
        buf.writeFloat(this.builder.hunger);
    }

    public static class Handler
    implements IMessageHandler<MessageSendMemberData, IMessage> {
        public IMessage onMessage(MessageSendMemberData message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                PartyMemberData player = new PartyMemberData(message.builder);
                if (MMOParties.localParty == null) {
                    MMOParties.localParty = new Party();
                }
                MMOParties.localParty.data.put(player.name, player);
            }
            return null;
        }
    }
}

