/*
 * Decompiled with CFR 0.152.
 */
package deathtags.stats;

import deathtags.core.ConfigHandler;
import deathtags.core.MMOParties;
import deathtags.helpers.CommandMessageHelper;
import deathtags.networking.MessageSendMemberData;
import deathtags.networking.MessageUpdateParty;
import deathtags.networking.PartyPacketDataBuilder;
import deathtags.stats.PartyMemberData;
import deathtags.stats.PlayerGroup;
import deathtags.stats.PlayerPing;
import deathtags.stats.PlayerStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Party
extends PlayerGroup {
    public List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    public List<String> playersOffline = new ArrayList<String>();
    public List<String> local_players = new ArrayList<String>();
    public Map<String, PartyMemberData> data = new HashMap<String, PartyMemberData>();

    public Party(EntityPlayer player) {
        this.leader = player;
        this.players.add(player);
        this.playersOffline.add(player.func_70005_c_());
        this.SendUpdate();
    }

    public Party() {
    }

    public static Party Create(EntityPlayer leader) {
        PlayerStats stats = MMOParties.GetStatsByName(leader.func_70005_c_());
        if (stats.InParty()) {
            CommandMessageHelper.SendError(leader, "rpgparties.message.party.exists", new String[0]);
            return stats.party;
        }
        stats.party = new Party(leader);
        CommandMessageHelper.SendInfo(leader, "rpgparties.message.party.create", new String[0]);
        return stats.party;
    }

    public static Party CreateGlobalParty(EntityPlayer player) {
        PlayerStats stats = MMOParties.GetStatsByName(player.func_70005_c_());
        if (stats.InParty()) {
            CommandMessageHelper.SendError(player, "rpgparties.message.party.exists", new String[0]);
            return stats.party;
        }
        stats.party = new Party(player);
        stats.party.leader = null;
        return stats.party;
    }

    public void Invite(EntityPlayer invoker, EntityPlayer player) {
        if (invoker == player && !ConfigHandler.Debug_Options.debuggingEnabled) {
            CommandMessageHelper.SendError(invoker, "rpgparties.message.error.invite.self", new String[0]);
            return;
        }
        PlayerStats targetPlayer = MMOParties.GetStats(player);
        PlayerStats invokerPlayer = MMOParties.GetStats(invoker);
        if (invokerPlayer.party.leader != invoker) {
            CommandMessageHelper.SendError(invoker, "rpgparties.message.party.privilege", new String[0]);
            return;
        }
        if ((targetPlayer.InParty() || targetPlayer.partyInvite != null) && !ConfigHandler.Debug_Options.debuggingEnabled) {
            CommandMessageHelper.SendError(invoker, "rpgparties.message.party.player.exists", player.func_70005_c_());
            return;
        }
        targetPlayer.partyInvite = this;
        CommandMessageHelper.SendInfo(invoker, "rpgparties.message.party.invited", player.func_70005_c_());
        CommandMessageHelper.SendInfoWithButton(player, "rpgparties.message.party.invite.from", invoker.func_70005_c_());
    }

    public void Join(EntityPlayer player, boolean displayMessage) {
        if (this.players.size() >= 4) {
            CommandMessageHelper.SendError(player, "rpgparties.message.party.full", new String[0]);
            return;
        }
        this.players.add(player);
        this.playersOffline.add(player.func_70005_c_());
        PlayerStats stats = MMOParties.GetStatsByName(player.func_70005_c_());
        stats.party = this;
        stats.partyInvite = null;
        if (displayMessage) {
            this.Broadcast(new TextComponentTranslation("rpgparties.message.party.joined", new Object[]{player.func_70005_c_()}));
        }
        for (EntityPlayer member : this.players) {
            this.SendPartyMemberData(member, true);
        }
        this.SendUpdate();
    }

    public void Leave(EntityPlayer player) {
        this.players.remove(player);
        this.Broadcast(new TextComponentTranslation("rpgparties.message.party.player.left", new Object[]{player.func_70005_c_()}));
        for (EntityPlayer member : this.players) {
            this.SendPartyMemberData(member, true);
        }
        this.SendPartyMemberData(player, true);
        if (player == this.leader && this.players.size() > 0) {
            this.leader = this.players.get(0);
        }
        this.SendUpdate();
        MMOParties.GetStats((EntityPlayer)player).party = null;
        this.SendMemberUpdate(player);
        if (this.players.size() <= 1 && !ConfigHandler.Server_Options.autoAssignParties) {
            this.Disband();
        }
        if (this.players.size() >= 1) {
            CommandMessageHelper.SendInfo(player, "rpgparties.message.party.leave", new String[0]);
        } else {
            CommandMessageHelper.SendInfo(player, "rpgparties.message.party.disbanded", new String[0]);
        }
    }

    public void Disband() {
        this.Broadcast(new TextComponentTranslation("rpgparties.message.party.disbanded", new Object[0]));
        this.leader = null;
        for (EntityPlayer member : this.players) {
            PlayerStats stats = MMOParties.GetStatsByName(member.func_70005_c_());
            stats.party = null;
            this.SendMemberUpdate(member);
        }
        this.players.clear();
    }

    public void SendMemberUpdate(EntityPlayer member) {
        if (!(member instanceof EntityPlayerMP)) {
            return;
        }
        MMOParties.network.sendTo((IMessage)new MessageUpdateParty(""), (EntityPlayerMP)member);
    }

    @Override
    public void Broadcast(TextComponentTranslation message) {
        for (EntityPlayer member : this.players) {
            member.func_145747_a((ITextComponent)message);
        }
    }

    @Override
    public EntityPlayer[] GetOnlinePlayers() {
        return this.players.toArray(new EntityPlayer[0]);
    }

    @Override
    public void SendUpdate() {
        CharSequence[] playerNames = new String[this.players.size()];
        int i = 0;
        for (EntityPlayer party_player : this.players) {
            playerNames[i] = party_player.func_70005_c_();
            ++i;
        }
        for (EntityPlayer party_player : this.players) {
            if (!(party_player instanceof EntityPlayerMP)) {
                return;
            }
            MMOParties.network.sendTo((IMessage)new MessageUpdateParty(String.join((CharSequence)",", playerNames)), (EntityPlayerMP)party_player);
        }
    }

    @Override
    public void SendPartyMemberData(EntityPlayer member, boolean bypassLimit) {
        if (this.IsDataDifferent(member) || bypassLimit) {
            if (!this.pings.containsKey(member.func_70005_c_())) {
                this.pings.put(member.func_70005_c_(), new PlayerPing(member, 0.0f, 0.0f, 0.0f, this.leader == member, 0.0f, 0.0f, 0.0f, 0.0f));
            }
            ((PlayerPing)this.pings.get(member.func_70005_c_())).Update(member.func_110143_aJ(), member.func_110138_aP(), member.func_70658_aO(), this.leader.func_70005_c_() == member.func_70005_c_(), member.func_110139_bj(), 0.0f, 0.0f);
            for (EntityPlayer party_player : this.players) {
                if (!(party_player instanceof EntityPlayerMP)) {
                    return;
                }
                MMOParties.network.sendTo((IMessage)new MessageSendMemberData(new PartyPacketDataBuilder().SetPlayer(member.func_70005_c_()).SetHealth(member.func_110143_aJ()).SetMaxHealth(member.func_110138_aP()).SetArmor(member.func_70658_aO()).SetLeader(this.leader.func_70005_c_() == member.func_70005_c_()).SetAbsorption(member.func_110139_bj()).SetHunger(member.func_71024_bL().func_75116_a())), (EntityPlayerMP)party_player);
            }
        }
    }

    @Override
    public boolean IsDataDifferent(EntityPlayer player) {
        return !this.pings.containsKey(player.func_70005_c_()) || ((PlayerPing)this.pings.get(player.func_70005_c_())).IsDifferent(player);
    }

    @Override
    public boolean IsMember(EntityPlayer player) {
        for (EntityPlayer member : this.players) {
            if (!member.func_70005_c_().equals(player.func_70005_c_())) continue;
            return true;
        }
        return false;
    }

    public boolean IsMemberOffline(EntityPlayer player) {
        return this.playersOffline.contains(player.func_70005_c_());
    }

    @Override
    public String GetGroupAlias() {
        return "party";
    }

    public void Teleport(EntityPlayer player, EntityPlayer target) {
        if (!this.IsMember(target)) {
            CommandMessageHelper.SendError(player, "rpgparties.message.error.party", new String[0]);
            return;
        }
        MMOParties.GetStatsByName(player.func_70005_c_()).StartTeleport(target);
    }
}

