/*
 * Decompiled with CFR 0.152.
 */
package deathtags.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import deathtags.config.ConfigHolder;
import deathtags.core.MMOParties;
import deathtags.core.events.EventClient;
import deathtags.helpers.CommandMessageHelper;
import deathtags.networking.MessageOpenUI;
import deathtags.networking.MessageUpdateParty;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkDirection;

public class PartyCommand {
    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"party").requires(commandSource -> true)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"sub", (ArgumentType)StringArgumentType.string()).executes(ctx -> PartyCommand.run((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"sub"), null))).suggests((sourceCommandContext, suggestionsBuilder) -> {
            suggestionsBuilder.suggest("invite").suggest("accept").suggest("deny").suggest("kick").suggest("leader").suggest("disband").suggest("gui").suggest("pvp");
            if (((Boolean)ConfigHolder.COMMON.allowPartyTP.get()).booleanValue()) {
                suggestionsBuilder.suggest("tp");
            }
            return suggestionsBuilder.buildFuture();
        }).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> PartyCommand.run((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"sub"), StringArgumentType.getString((CommandContext)ctx, (String)"player")))).suggests((sourceCommandContext, suggestionsBuilder) -> PartyCommand.getSuggestions((CommandContext<CommandSource>)sourceCommandContext, suggestionsBuilder))));
    }

    private static CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSource> ctx, SuggestionsBuilder builder) {
        String argument;
        switch (argument = StringArgumentType.getString(ctx, (String)"sub").trim()) {
            case "invite": {
                ((CommandSource)ctx.getSource()).func_197028_i().func_184103_al().func_181057_v().forEach(player -> builder.suggest(player.func_200200_C_().getString()));
                break;
            }
            case "kick": 
            case "leader": {
                ServerPlayerEntity player2 = null;
                try {
                    player2 = ((CommandSource)ctx.getSource()).func_197035_h();
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
                MMOParties.GetStats((PlayerEntity)player2).party.players.forEach(playerEntity -> builder.suggest(playerEntity.func_200200_C_().getString()));
            }
        }
        return builder.buildFuture();
    }

    private static int run(CommandContext<CommandSource> context, String sub, String targetStr) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        PlayerEntity target = null;
        if (targetStr != null) {
            ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_152612_a(targetStr);
        }
        if (targetStr != null && target == null) {
            CommandMessageHelper.SendError((PlayerEntity)player, String.format("The player %s is not online.", targetStr), new String[0]);
            return 0;
        }
        if (player.func_130014_f_().field_72995_K) {
            return 0;
        }
        PlayerStats stats = MMOParties.GetStats((PlayerEntity)player);
        switch (sub) {
            case "tp": {
                if (!((Boolean)ConfigHolder.COMMON.allowPartyTP.get()).booleanValue()) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "rpgparties.message.error.teleport.server", new String[0]);
                    return 0;
                }
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "rpgparties.message.error.teleport.party", new String[0]);
                    return 0;
                }
                stats.party.Teleport((PlayerEntity)player, target);
                break;
            }
            case "kick": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "rpgparties.message.error.party", new String[0]);
                    return 0;
                }
                stats.party.Leave(target);
                break;
            }
            case "invite": {
                if (targetStr == null) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "rpgparties.message.error.argument", player.func_200200_C_().func_150261_e());
                    return 0;
                }
                if (!stats.InParty()) {
                    Party.Create((PlayerEntity)player);
                }
                stats.party.Invite((PlayerEntity)player, target);
                break;
            }
            case "accept": {
                if (stats.partyInvite == null) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "rpgparties.message.error.invite", new String[0]);
                    return 0;
                }
                stats.partyInvite.Join((PlayerEntity)player, true);
                break;
            }
            case "deny": {
                if (stats.partyInvite == null) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "rpgparties.message.error.invite", new String[0]);
                    return 0;
                }
                stats.partyInvite = null;
                CommandMessageHelper.SendInfo((PlayerEntity)player, "rpgparties.message.party.deny", new String[0]);
                break;
            }
            case "leave": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "rpgparties.message.error.party", new String[0]);
                    return 0;
                }
                stats.party.Leave((PlayerEntity)player);
                stats.party = null;
                break;
            }
            case "leader": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "You are not currently in a party.", new String[0]);
                    return 0;
                }
                if (stats.party.leader != player) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "Only the leader may promote members.", new String[0]);
                    return 0;
                }
                if (targetStr == null) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "rpgparties.message.error.argument", player.func_200200_C_().func_150261_e());
                    return 0;
                }
                stats.party.MakeLeader((PlayerEntity)player);
                break;
            }
            case "disband": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "rpgparties.message.error.party", new String[0]);
                    return 0;
                }
                if (stats.party.leader != player) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "rpgparties.message.error.disband", new String[0]);
                    return 0;
                }
                stats.party.Disband();
                break;
            }
            case "gui": {
                if (!player.func_130014_f_().field_72995_K) {
                    MMOParties.network.sendTo((Object)new MessageOpenUI(), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                    break;
                }
                if (!Minecraft.func_71410_x().func_71356_B()) break;
                EventClient.OpenPartyScreen();
                break;
            }
            case "pvp": {
                stats.pvpEnabled = !stats.pvpEnabled;
                CommandMessageHelper.SendInfo((PlayerEntity)player, stats.pvpEnabled ? "rpgparties.message.pvp.enabled" : "rpgparties.message.pvp.disabled", new String[0]);
                break;
            }
            case "add": {
                MMOParties.network.sendTo((Object)new MessageUpdateParty("dev,devtestman2,dev3"), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                break;
            }
        }
        return 0;
    }
}

