/*
 * Decompiled with CFR 0.152.
 */
package deathtags.core;

import deathtags.api.PartyHelper;
import deathtags.commands.PartyCommand;
import deathtags.config.ConfigHolder;
import deathtags.core.events.EventClient;
import deathtags.core.events.EventCommon;
import deathtags.gui.PartyList;
import deathtags.gui.builders.BuilderAbsorption;
import deathtags.gui.builders.BuilderArmor;
import deathtags.gui.builders.BuilderHealth;
import deathtags.gui.builders.BuilderHunger;
import deathtags.gui.builders.BuilderLeader;
import deathtags.gui.builders.BuilderName;
import deathtags.networking.BuilderData;
import deathtags.networking.MessageHandleMenuAction;
import deathtags.networking.MessageOpenUI;
import deathtags.networking.MessagePartyInvite;
import deathtags.networking.MessageSendMemberData;
import deathtags.networking.MessageUpdateParty;
import deathtags.networking.PartyPacketDataBuilder;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

@Mod(value="mmoparties")
public class MMOParties {
    public static final String MODID = "mmoparties";
    public static Party localParty;
    public static String partyInviter;
    public static Map<PlayerEntity, PlayerStats> PlayerStats;
    private static final String PROTOCOL_VERSION = "2";
    public static KeyBinding OPEN_GUI_KEY;
    public static final SimpleChannel network;

    public MMOParties() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHolder.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigHolder.CLIENT_SPEC);
        MMOParties.RegisterCompatibility(new BuilderLeader(), new BuilderLeader.Renderer());
        MMOParties.RegisterCompatibility(new BuilderName(), new BuilderName.Renderer());
        MMOParties.RegisterCompatibility(new BuilderHealth(), new BuilderHealth.NuggetBar());
        MMOParties.RegisterCompatibility(new BuilderAbsorption(), new BuilderAbsorption.NuggetBar());
        MMOParties.RegisterCompatibility(new BuilderHunger(), new BuilderHunger.NuggetBar());
        MMOParties.RegisterCompatibility(new BuilderArmor(), new BuilderArmor.NuggetBar());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::OnSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::OnClientInitialize);
        MinecraftForge.EVENT_BUS.addListener(this::OnCommandRegister);
        MinecraftForge.EVENT_BUS.addListener(this::OnServerInitialize);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void OnSetup(FMLCommonSetupEvent event) {
        this.SetupNetworking();
        MinecraftForge.EVENT_BUS.register((Object)new EventCommon());
        MinecraftForge.EVENT_BUS.register((Object)new EventClient());
    }

    public void SetupNetworking() {
        network.registerMessage(1, MessageUpdateParty.class, MessageUpdateParty::encode, MessageUpdateParty::decode, MessageUpdateParty.Handler::handle);
        network.registerMessage(2, MessageSendMemberData.class, MessageSendMemberData::encode, MessageSendMemberData::decode, MessageSendMemberData.Handler::handle);
        network.registerMessage(3, MessageHandleMenuAction.class, MessageHandleMenuAction::encode, MessageHandleMenuAction::decode, MessageHandleMenuAction.Handler::handle);
        network.registerMessage(4, MessagePartyInvite.class, MessagePartyInvite::encode, MessagePartyInvite::decode, MessagePartyInvite.Handler::handle);
    }

    public void OnServerInitialize(FMLServerStartingEvent event) {
        PartyHelper.Server.server = event.getServer();
        network.registerMessage(5, MessageOpenUI.class, MessageOpenUI::encode, MessageOpenUI::decode, MessageOpenUI.Handler::handleServer);
    }

    public void OnClientInitialize(FMLClientSetupEvent event) {
        PartyList.init();
        network.registerMessage(5, MessageOpenUI.class, MessageOpenUI::encode, MessageOpenUI::decode, MessageOpenUI.Handler::handle);
        OPEN_GUI_KEY = new KeyBinding("key.opengui.desc", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputMappings.Type.KEYSYM, 80, "key.mmoparties.category");
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_GUI_KEY);
    }

    public void OnCommandRegister(RegisterCommandsEvent event) {
        event.getDispatcher().register(PartyCommand.register());
        PermissionAPI.registerNode((String)"rpgparties.*", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"The base permission");
    }

    public static PlayerStats GetStatsByName(String username) {
        for (Map.Entry<PlayerEntity, PlayerStats> plr : PlayerStats.entrySet()) {
            if (!plr.getKey().func_200200_C_().func_150261_e().equals(username)) continue;
            return plr.getValue();
        }
        return null;
    }

    public static PlayerStats GetStats(PlayerEntity player) {
        return MMOParties.GetStatsByName(player.func_200200_C_().getString());
    }

    public static void RegisterCompatibility(BuilderData builder, PartyList.NuggetBar bar) {
        ArrayList<PartyList.NuggetBar> bars = new ArrayList<PartyList.NuggetBar>();
        for (int i = 0; i < PartyList.nuggetBars.length; ++i) {
            bars.add(PartyList.nuggetBars[i]);
        }
        bars.add(bar);
        PartyList.nuggetBars = bars.toArray(new PartyList.NuggetBar[0]);
        PartyPacketDataBuilder.builderData.add(builder);
    }

    static {
        PlayerStats = new HashMap<PlayerEntity, PlayerStats>();
        network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "sync")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

