/*
 * Decompiled with CFR 0.152.
 */
package deathtags.core.events;

import deathtags.api.PartyHelper;
import deathtags.api.relation.EnumRelation;
import deathtags.config.ConfigHolder;
import deathtags.core.MMOParties;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventCommon {
    public static Party globalParty = null;

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!MMOParties.PlayerStats.containsKey(player)) {
            MMOParties.PlayerStats.put(player, new PlayerStats(player));
        }
        this.RejoinLastParty(player);
        if (((Boolean)ConfigHolder.COMMON.autoAssignParties.get()).booleanValue()) {
            this.HandleGlobalParty(player);
        }
    }

    public void RejoinLastParty(PlayerEntity player) {
        for (ServerPlayerEntity serverPlayer : player.func_184102_h().func_184103_al().func_181057_v()) {
            PlayerStats svStats = MMOParties.GetStats((PlayerEntity)serverPlayer);
            if (!svStats.InParty() || !svStats.party.IsMemberOffline(player)) continue;
            svStats.party.Join(player, false);
            svStats.party.Broadcast(new TranslationTextComponent("rpgparties.party.player.returned", new Object[]{player.func_200200_C_().getString()}));
        }
    }

    public void HandleGlobalParty(PlayerEntity player) {
        if (globalParty == null) {
            globalParty = Party.CreateGlobalParty(player);
        } else if (!globalParty.IsMember(player)) {
            globalParty.Join(player, false);
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerStats playerStats = MMOParties.GetStats(event.getPlayer());
        MMOParties.PlayerStats.remove(event.getPlayer());
        if (!playerStats.InParty()) {
            return;
        }
        playerStats.party.players.remove(event.getPlayer());
        if (playerStats.party.players.size() > 0) {
            playerStats.party.MakeLeader(playerStats.party.players.get(0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void OnPlayerHurt(LivingHurtEvent event) {
        if (!((Boolean)ConfigHolder.COMMON.friendlyFireDisabled.get()).booleanValue()) {
            return;
        }
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (!(event.getEntityLiving() instanceof PlayerEntity) || !(event.getSource().func_76364_f() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        PlayerEntity source = (PlayerEntity)event.getSource().func_76364_f();
        if (MMOParties.GetStats((PlayerEntity)source).pvpEnabled) {
            return;
        }
        if (PartyHelper.Server.GetRelation((ServerPlayerEntity)player, (ServerPlayerEntity)source) == EnumRelation.PARTY) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void OnPlayerGameTick(TickEvent.PlayerTickEvent event) {
        PlayerStats stats = MMOParties.GetStats(event.player);
        if (stats == null) {
            return;
        }
        stats.TickTeleport();
        if (stats.party != null) {
            stats.party.SendPartyMemberData(event.player, false);
        }
    }
}

