/*
 * Decompiled with CFR 0.152.
 */
package deathtags.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import deathtags.config.ConfigHolder;
import deathtags.core.MMOParties;
import deathtags.gui.UISpec;
import deathtags.networking.BuilderData;
import deathtags.stats.PartyMemberData;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber
public class PartyList {
    public static final ResourceLocation TEXTURE_ICON = new ResourceLocation("mmoparties", "textures/icons.png");
    public static final ResourceLocation HEART_TEXTURE = new ResourceLocation("minecraft", "textures/gui/icons.png");
    private static Minecraft mc;
    private static int updateCounter;
    private static Random random;
    private static MatrixStack stack;
    private static boolean renderAscending;
    private static boolean renderOpposite;
    public static NuggetBar[] nuggetBars;

    public PartyList() {
        random = new Random();
    }

    public static UISpec GetAnchorOffset() {
        switch ((String)ConfigHolder.CLIENT.anchorPoint.get()) {
            case "top-left": {
                return new UISpec(8, 0);
            }
            case "bottom-left": {
                renderAscending = true;
                return new UISpec(8, mc.func_228018_at_().func_198087_p());
            }
            case "top-right": {
                return new UISpec(mc.func_228018_at_().func_198107_o() - 5, 0);
            }
            case "bottom-right": {
                renderAscending = true;
                return new UISpec(mc.func_228018_at_().func_198107_o(), mc.func_228018_at_().func_198087_p() - 20);
            }
        }
        System.out.println("Invalid anchor position selected.");
        return new UISpec(0, 0);
    }

    public static int Draw(float current, float max, UISpec UI, int backgroundOffset, int halfOffset, boolean compact, boolean render) {
        if (!render) {
            return -1;
        }
        if (!compact) {
            return PartyList.DrawNuggetBar(current, max, UI, backgroundOffset, halfOffset);
        }
        return PartyList.DrawNuggetBarCompact(current, UI, backgroundOffset);
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if ((event.getType() == RenderGameOverlayEvent.ElementType.HEALTH || event.getType() == RenderGameOverlayEvent.ElementType.ARMOR) && ((Boolean)ConfigHolder.CLIENT.hideGUI.get()).booleanValue()) {
            event.setCanceled(true);
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        int lastOffset = 0;
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        mc = Minecraft.func_71410_x();
        if (MMOParties.localParty != null && MMOParties.localParty.local_players.size() >= 1) {
            int pN = 0;
            for (PartyMemberData data : MMOParties.localParty.data.values()) {
                if (((Boolean)ConfigHolder.CLIENT.hideSelf.get()).booleanValue() && data.name.equals(PartyList.mc.field_71439_g.func_200200_C_().getString())) continue;
                lastOffset += this.RenderMember(data, lastOffset, pN, MMOParties.localParty.local_players.size() > 4 || (Boolean)ConfigHolder.CLIENT.useSimpleUI.get() == true);
                ++pN;
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
    }

    public static int DrawNuggetBarCompact(float current, UISpec UI, int backgroundOffset) {
        int left = UI.x;
        int top = UI.y;
        int startX = left;
        int startY = top;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(UI.texture);
        Minecraft.func_71410_x().field_71456_v.func_238474_b_(stack, startX, startY, backgroundOffset, UI.texture_y, 9, 9);
        Minecraft.func_71410_x().field_71456_v.func_238474_b_(stack, startX, startY, UI.texture_x, UI.texture_y, 9, 9);
        PartyList.mc.field_71466_p.func_238421_b_(stack, String.format("%s", Math.floor(current)), (float)(startX + 12), (float)startY, 0xFFFFFF);
        return 6;
    }

    int RenderMember(PartyMemberData data, int lastOffset, int pN, boolean compact) {
        if (data == null) {
            return 0;
        }
        int iconRows = 0;
        int additionalOffset = 0;
        UISpec defaultOffset = PartyList.GetAnchorOffset();
        int yOffset = 15 * (pN + 1) + lastOffset;
        int posX = defaultOffset.x;
        if (renderAscending) {
            yOffset = -yOffset;
        }
        if (compact) {
            yOffset = (int)((double)yOffset / 1.7) + 4;
            nuggetBars[1].Render(data.additionalData[1], posX, defaultOffset.y - 10 + yOffset, true);
            nuggetBars[2].Render(data.additionalData[2], posX + 30 + 4 * data.name.length(), defaultOffset.y - 10 + yOffset, true);
            return additionalOffset;
        }
        for (int i = 0; i < nuggetBars.length; ++i) {
            if (data.additionalData[i] == null) continue;
            int rowOffset = 12 * iconRows;
            if (renderAscending) {
                rowOffset = -rowOffset;
            }
            int offset = nuggetBars[i].Render(data.additionalData[i], posX, defaultOffset.y + rowOffset + yOffset, false);
            additionalOffset += offset;
            if (offset == -1) continue;
            ++iconRows;
        }
        return additionalOffset;
    }

    public static int DrawNuggetBar(float current, float max, UISpec UI, int backgroundOffset, int halfOffset) {
        UI.x /= 2;
        int length = 0;
        int bars = 0;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(UI.texture);
        int i = 0;
        while ((float)i < max / 2.0f) {
            int dropletHalf = i * 2 + 1;
            int nuggetX = UI.x + length * 8;
            int offsetY = UI.y;
            int xOffset = 4 * bars;
            if (renderOpposite) {
                xOffset = -xOffset;
            }
            if (max > 6.0f && current <= 6.0f && (float)updateCounter % (current * 3.0f + 1.0f) == 0.0f) {
                offsetY = UI.y + (random.nextInt(3) - 1);
            }
            Minecraft.func_71410_x().field_71456_v.func_238474_b_(stack, nuggetX, offsetY + xOffset, backgroundOffset, UI.texture_y, 9, 9);
            if ((int)current > dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.func_238474_b_(stack, nuggetX, offsetY + xOffset, UI.texture_x, UI.texture_y, 9, 9);
            } else if ((int)current == dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.func_238474_b_(stack, nuggetX, offsetY + xOffset, UI.texture_x + halfOffset, UI.texture_y, 9, 9);
            }
            if (++length > 9) {
                ++bars;
                length = 0;
            }
            ++i;
        }
        return 6 * (bars + 1);
    }

    public static int DrawText(String text, UISpec location) {
        PartyList.mc.field_71466_p.func_238405_a_(stack, text, (float)location.x, (float)location.y, 0xFFFFFF);
        return 8;
    }

    public static int DrawResource(UISpec ui) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ui.texture);
        Minecraft.func_71410_x().field_71456_v.func_238474_b_(stack, ui.x, ui.y, ui.texture_x, ui.texture_y, ui.width, ui.height);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ForgeIngameGui.field_230665_h_);
        return ui.height;
    }

    public static void init() {
        System.out.println("Load GUI");
        MinecraftForge.EVENT_BUS.register((Object)new PartyList());
    }

    static {
        updateCounter = 0;
        stack = new MatrixStack();
        renderAscending = false;
        renderOpposite = false;
        nuggetBars = new NuggetBar[0];
    }

    public static interface NuggetBar {
        public int Render(BuilderData var1, int var2, int var3, boolean var4);
    }
}

