/*
 * Decompiled with CFR 0.152.
 */
package deathtags.gui.builders;

import deathtags.gui.PartyList;
import deathtags.gui.UISpec;
import deathtags.networking.BuilderData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;

public class BuilderStatuses
implements BuilderData {
    Effect[] effects;

    @Override
    public void OnWrite(PacketBuffer buffer, PlayerEntity player) {
        buffer.writeInt(player.func_70651_bq().size());
        player.func_70651_bq().forEach(effectInstance -> buffer.writeInt(Effect.func_188409_a((Effect)effectInstance.func_188419_a())));
    }

    @Override
    public void OnRead(PacketBuffer buffer) {
        int count = buffer.readInt();
        this.effects = new Effect[count];
        for (int i = 0; i < count; ++i) {
            int id = buffer.readInt();
            this.effects[i] = Effect.func_188412_a((int)id);
        }
    }

    @Override
    public boolean IsDifferent(PlayerEntity player) {
        return this.effects.length != player.func_70651_bq().size();
    }

    public static class Renderer
    implements PartyList.NuggetBar {
        @Override
        public int Render(BuilderData data, int xOffset, int yOffset, boolean compact) {
            BuilderStatuses statuses = (BuilderStatuses)data;
            for (int i = 0; i < statuses.effects.length; ++i) {
                PartyList.DrawResource(new UISpec(PartyList.TEXTURE_ICON, xOffset + 10 * i, yOffset, 0, 0, 9, 9));
                ResourceLocation location = new ResourceLocation(statuses.effects[i].getRegistryName().func_110624_b(), "textures/mob_effect/" + statuses.effects[i].getRegistryName().func_110623_a() + ".png");
                System.out.println(location.toString());
                PartyList.DrawResource(new UISpec(location, xOffset, yOffset, 0, 0, 9, 9));
            }
            return 0;
        }
    }
}

