/*
 * Decompiled with CFR 0.152.
 */
package deathtags.networking;

import com.google.common.base.Charsets;
import deathtags.config.ConfigHolder;
import deathtags.core.MMOParties;
import deathtags.networking.EnumPartyGUIAction;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageHandleMenuAction {
    public final String name;
    public final EnumPartyGUIAction action;

    public MessageHandleMenuAction(CharSequence charSequence, EnumPartyGUIAction action) {
        this.name = charSequence.toString();
        this.action = action;
    }

    public static MessageHandleMenuAction decode(PacketBuffer buf) {
        return new MessageHandleMenuAction(buf.readCharSequence(buf.readInt(), Charsets.UTF_8), EnumPartyGUIAction.values()[buf.readInt()]);
    }

    public static void encode(MessageHandleMenuAction msg, PacketBuffer buf) {
        buf.writeInt(msg.name.length());
        buf.writeCharSequence((CharSequence)msg.name, Charsets.UTF_8);
        buf.writeInt(msg.action.ordinal());
    }

    public static class Handler {
        public static void handle(MessageHandleMenuAction pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().setPacketHandled(true);
            PlayerStats stats = MMOParties.GetStatsByName(ctx.get().getSender().func_200200_C_().getString());
            switch (pkt.action) {
                case INVITE: {
                    if (!stats.InParty()) {
                        stats.party = new Party((PlayerEntity)ctx.get().getSender());
                    }
                    if (stats.player != stats.party.leader) {
                        return;
                    }
                    if (pkt.name == "" && ((Boolean)ConfigHolder.COMMON.allowInviteAll.get()).booleanValue()) {
                        ctx.get().getSender().field_71133_b.func_184103_al().func_181057_v().forEach(serverPlayerEntity -> stats.party.Invite((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), (PlayerEntity)serverPlayerEntity));
                        break;
                    }
                    stats.party.Invite((PlayerEntity)ctx.get().getSender(), (PlayerEntity)ctx.get().getSender().field_71133_b.func_184103_al().func_152612_a(pkt.name));
                    break;
                }
                case KICK: {
                    if (!stats.InParty()) {
                        return;
                    }
                    if (stats.player != stats.party.leader) {
                        return;
                    }
                    stats.party.Leave((PlayerEntity)ctx.get().getSender().field_71133_b.func_184103_al().func_152612_a(pkt.name));
                    break;
                }
                case LEADER: {
                    if (!stats.InParty()) {
                        return;
                    }
                    if (stats.player != stats.party.leader) {
                        return;
                    }
                    stats.party.MakeLeader((PlayerEntity)ctx.get().getSender().field_71133_b.func_184103_al().func_152612_a(pkt.name));
                    break;
                }
                case DISBAND: {
                    if (!stats.InParty()) {
                        return;
                    }
                    if (stats.player != stats.party.leader) {
                        return;
                    }
                    stats.party.Disband();
                    break;
                }
                case LEAVE: {
                    if (!stats.InParty()) {
                        return;
                    }
                    stats.Leave();
                    break;
                }
                case ACCEPT: {
                    if (stats.partyInvite == null) {
                        return;
                    }
                    stats.partyInvite.Join(stats.player, true);
                    break;
                }
                case DENY: {
                    if (stats.partyInvite == null) {
                        return;
                    }
                    stats.partyInvite = null;
                }
            }
        }
    }
}

