/*
 * Decompiled with CFR 0.152.
 */
package deathtags.networking;

import com.google.common.base.Charsets;
import deathtags.core.MMOParties;
import deathtags.networking.BuilderData;
import deathtags.networking.PartyPacketDataBuilder;
import deathtags.stats.Party;
import deathtags.stats.PartyMemberData;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSendMemberData {
    private PartyPacketDataBuilder builder;

    public MessageSendMemberData() {
    }

    public MessageSendMemberData(PartyPacketDataBuilder data) {
        this.builder = data;
    }

    public static MessageSendMemberData decode(PacketBuffer buf) {
        MessageSendMemberData data = new MessageSendMemberData(new PartyPacketDataBuilder().SetName(buf.readCharSequence(buf.readInt(), Charsets.UTF_8).toString()));
        for (int i = 0; i < PartyPacketDataBuilder.builderData.size(); ++i) {
            Class<?> aClass = PartyPacketDataBuilder.builderData.get(i).getClass();
            try {
                BuilderData builder = (BuilderData)aClass.newInstance();
                builder.OnRead(buf);
                data.builder.AddData(i, builder);
                continue;
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }

    public static void encode(MessageSendMemberData msg, PacketBuffer buf) {
        buf.writeInt(msg.builder.nameLength);
        buf.writeCharSequence((CharSequence)msg.builder.playerId, Charsets.UTF_8);
        PartyPacketDataBuilder.builderData.forEach(builderData -> builderData.OnWrite(buf, msg.builder.player));
    }

    public static class Handler {
        public static void handle(MessageSendMemberData message, Supplier<NetworkEvent.Context> ctx) {
            PartyMemberData player = new PartyMemberData(message.builder);
            if (MMOParties.localParty == null) {
                MMOParties.localParty = new Party();
            }
            MMOParties.localParty.data.put(player.name, player);
            ctx.get().setPacketHandled(true);
        }
    }
}

