/*
 * Decompiled with CFR 0.152.
 */
package deathtags.networking;

import com.google.common.base.Charsets;
import deathtags.core.MMOParties;
import deathtags.stats.Party;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateParty {
    public final String members;

    public MessageUpdateParty(CharSequence charSequence) {
        this.members = charSequence.toString();
    }

    public static MessageUpdateParty decode(PacketBuffer buf) {
        return new MessageUpdateParty(buf.readCharSequence(buf.readInt(), Charsets.UTF_8));
    }

    public static void encode(MessageUpdateParty msg, PacketBuffer buf) {
        buf.writeInt(msg.members.length());
        buf.writeCharSequence((CharSequence)msg.members, Charsets.UTF_8);
    }

    public static class Handler {
        public static void handle(MessageUpdateParty pkt, Supplier<NetworkEvent.Context> ctx) {
            ArrayList<String> players = new ArrayList<String>(Arrays.asList(pkt.members.split(",")));
            if (MMOParties.localParty == null) {
                MMOParties.localParty = new Party();
            }
            MMOParties.localParty.local_players = players;
            if (pkt.members == "") {
                MMOParties.localParty = null;
            }
            ctx.get().setPacketHandled(true);
        }
    }
}

