/*
 * Decompiled with CFR 0.152.
 */
package deathtags.stats;

import deathtags.config.ConfigHolder;
import deathtags.core.MMOParties;
import deathtags.helpers.CommandMessageHelper;
import deathtags.networking.MessagePartyInvite;
import deathtags.networking.MessageSendMemberData;
import deathtags.networking.MessageUpdateParty;
import deathtags.networking.PartyPacketDataBuilder;
import deathtags.stats.PartyMemberData;
import deathtags.stats.PlayerGroup;
import deathtags.stats.PlayerStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkDirection;

public class Party
extends PlayerGroup {
    public List<PlayerEntity> players = new ArrayList<PlayerEntity>();
    public List<String> playersOffline = new ArrayList<String>();
    public List<String> local_players = new ArrayList<String>();
    public Map<String, PartyMemberData> data = new HashMap<String, PartyMemberData>();

    public Party(PlayerEntity player) {
        this.leader = player;
        this.players.add(player);
        this.playersOffline.add(player.func_200200_C_().getString());
        this.SendUpdate();
    }

    public Party() {
    }

    public static Party Create(PlayerEntity leader) {
        PlayerStats stats = MMOParties.GetStatsByName(leader.func_200200_C_().func_150261_e());
        if (stats.InParty()) {
            CommandMessageHelper.SendError(leader, "rpgparties.message.party.exists", new String[0]);
            return stats.party;
        }
        stats.party = new Party(leader);
        CommandMessageHelper.SendInfo(leader, "rpgparties.message.party.create", new String[0]);
        return stats.party;
    }

    public static Party CreateGlobalParty(PlayerEntity player) {
        PlayerStats stats = MMOParties.GetStatsByName(player.func_200200_C_().func_150261_e());
        stats.party = new Party(player);
        stats.party.leader = null;
        return stats.party;
    }

    public void Invite(PlayerEntity invoker, PlayerEntity player) {
        PlayerStats targetPlayer = MMOParties.GetStats(player);
        if (invoker == player && !((Boolean)ConfigHolder.COMMON.debugMode.get()).booleanValue()) {
            CommandMessageHelper.SendInfo(invoker, "rpgparties.message.invite.self", new String[0]);
            return;
        }
        PlayerStats invokerPlayer = MMOParties.GetStats(invoker);
        if (invokerPlayer.party.leader != invoker) {
            CommandMessageHelper.SendError(invoker, "rpgparties.message.party.privilege", new String[0]);
            return;
        }
        if ((targetPlayer.InParty() || targetPlayer.partyInvite != null) && !((Boolean)ConfigHolder.COMMON.debugMode.get()).booleanValue()) {
            CommandMessageHelper.SendError(invoker, "rpgparties.message.party.player.exists", player.func_200200_C_().func_150261_e());
            return;
        }
        targetPlayer.partyInvite = this;
        MMOParties.network.sendTo((Object)new MessagePartyInvite(invoker.func_200200_C_().getString()), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        CommandMessageHelper.SendInfo(invoker, "rpgparties.message.party.invited", player.func_200200_C_().func_150261_e());
        CommandMessageHelper.SendInfoWithButton(player, "rpgparties.message.party.invite.from", invoker.func_200200_C_().func_150261_e());
        CommandMessageHelper.SendInfo(player, "rpgparties.message.party.menu", new String[0]);
    }

    public void Join(PlayerEntity player, boolean displayMessage) {
        if (this.players.size() >= 10) {
            CommandMessageHelper.SendError(player, "rpgparties.message.party.full", new String[0]);
            return;
        }
        this.players.add(player);
        this.playersOffline.add(player.func_200200_C_().getString());
        PlayerStats stats = MMOParties.GetStatsByName(player.func_200200_C_().func_150261_e());
        stats.party = this;
        stats.partyInvite = null;
        if (displayMessage) {
            this.Broadcast(new TranslationTextComponent("rpgparties.message.party.joined", new Object[]{player.func_200200_C_().func_150261_e()}));
        }
        for (PlayerEntity member : this.players) {
            this.SendPartyMemberData(member, true);
        }
        this.SendUpdate();
    }

    public void Leave(PlayerEntity player) {
        this.players.remove(player);
        this.Broadcast(new TranslationTextComponent("rpgparties.message.party.player.left", new Object[]{player.func_200200_C_().func_150261_e()}));
        for (PlayerEntity member : this.players) {
            this.SendPartyMemberData(member, true);
        }
        this.SendPartyMemberData(player, true);
        if (player == this.leader && this.players.size() > 0) {
            this.leader = this.players.get(0);
        }
        this.SendUpdate();
        MMOParties.GetStats((PlayerEntity)player).party = null;
        MMOParties.network.sendTo((Object)new MessageUpdateParty(""), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        if (this.players.size() == 1 && !((Boolean)ConfigHolder.COMMON.autoAssignParties.get()).booleanValue()) {
            this.Disband();
        }
        CommandMessageHelper.SendInfo(player, "rpgparties.message.party.leave", new String[0]);
    }

    public void Disband() {
        this.Broadcast(new TranslationTextComponent("rpgparties.message.party.disbanded"));
        this.leader = null;
        for (PlayerEntity member : this.players) {
            PlayerStats stats = MMOParties.GetStatsByName(member.func_200200_C_().func_150261_e());
            stats.party = null;
            MMOParties.network.sendTo((Object)new MessageUpdateParty(""), ((ServerPlayerEntity)member).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
        this.players.clear();
    }

    @Override
    public void Broadcast(TranslationTextComponent message) {
        for (PlayerEntity member : this.players) {
            member.func_146105_b((ITextComponent)message, false);
        }
    }

    @Override
    public PlayerEntity[] GetOnlinePlayers() {
        return this.players.toArray(new PlayerEntity[0]);
    }

    @Override
    public void SendUpdate() {
        CharSequence[] playerNames = new String[this.players.size()];
        int i = 0;
        for (PlayerEntity party_player : this.players) {
            playerNames[i] = party_player.func_200200_C_().func_150261_e();
            ++i;
        }
        for (PlayerEntity party_player : this.players) {
            if (!(party_player instanceof ServerPlayerEntity)) {
                return;
            }
            MMOParties.network.sendTo((Object)new MessageUpdateParty(String.join((CharSequence)",", playerNames)), ((ServerPlayerEntity)party_player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @Override
    public void SendPartyMemberData(PlayerEntity member, boolean bypassLimit) {
        if (this.IsDataDifferent(member) || bypassLimit) {
            for (PlayerEntity party_player : this.players) {
                if (!(party_player instanceof ServerPlayerEntity)) {
                    return;
                }
                PartyPacketDataBuilder builder = new PartyPacketDataBuilder().SetPlayer(member).SetHealth(member.func_110143_aJ()).SetMaxHealth(member.func_110138_aP()).SetArmor(member.func_70658_aO()).SetLeader(this.leader == member).SetAbsorption(member.func_110139_bj()).SetHunger(member.func_71024_bL().func_75116_a());
                MMOParties.network.sendTo((Object)new MessageSendMemberData(builder), ((ServerPlayerEntity)party_player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @Override
    public boolean IsDataDifferent(PlayerEntity player) {
        return !this.data.containsKey(player) || this.data.get(player).IsDifferent(player);
    }

    @Override
    public boolean IsMember(PlayerEntity player) {
        for (PlayerEntity member : this.players) {
            if (!member.func_200200_C_().equals(player.func_200200_C_())) continue;
            return true;
        }
        return false;
    }

    public boolean IsMemberOffline(PlayerEntity player) {
        return this.playersOffline.contains(player.func_200200_C_().getString());
    }

    @Override
    public String GetGroupAlias() {
        return "party";
    }

    public void Teleport(PlayerEntity player, PlayerEntity target) {
        if (!this.IsMember(target)) {
            CommandMessageHelper.SendError(player, "rpgparties.message.error.party", new String[0]);
            return;
        }
        MMOParties.GetStatsByName(player.func_200200_C_().func_150261_e()).StartTeleport(target);
    }
}

