/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuuki14202028.minecraft.thirst.thirst.mixins;

import com.github.yuuki14202028.minecraft.thirst.thirst.PacketHandler;
import com.github.yuuki14202028.minecraft.thirst.thirst.mixins.PlayerMixin;
import com.github.yuuki14202028.minecraft.thirst.thirst.packets.ClientboundSetThirstPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends PlayerMixin {
    @Shadow
    public ServerGamePacketListenerImpl f_8906_;
    int lastSentThirst = -99999999;
    boolean lastFoodSaturationZero = true;
    int lastRecordedThirstLevel = Integer.MIN_VALUE;

    @Shadow
    protected abstract void m_9104_(ObjectiveCriteria var1, int var2);

    protected ServerPlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"restoreFrom"}, at={@At(value="FIELD", target="Lnet/minecraft/server/level/ServerPlayer;foodData:Lnet/minecraft/world/food/FoodData;", opcode=180)})
    private void injectRestoreFromWithThirstData(ServerPlayer player, boolean bool, CallbackInfo ci) {
        this.setThirstData(((PlayerMixin)player).getThirstData());
    }

    @Inject(method={"restoreFrom"}, at={@At(value="FIELD", target="Lnet/minecraft/server/level/ServerPlayer;lastSentFood:I", opcode=181)})
    private void injectRestoreFromWithLastSentThirst(ServerPlayer player, boolean bool, CallbackInfo ci) {
        this.lastSentThirst = -1;
    }

    @Inject(method={"doTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getHealth()F", ordinal=0)})
    private void injectDoTickWithLastSentThirst(CallbackInfo ci) {
        if (this.lastSentThirst != this.getThirstData().getThirstLevel() || this.getThirstData().getSaturationLevel() == 0.0f != this.lastFoodSaturationZero) {
            PacketHandler.INSTANCE.getConnection().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this), (Object)new ClientboundSetThirstPacket(this.getThirstData().getThirstLevel(), this.getThirstData().getSaturationLevel()));
            this.lastSentThirst = this.getThirstData().getThirstLevel();
            this.lastFoodSaturationZero = this.getThirstData().getSaturationLevel() == 0.0f;
        }
    }

    @Inject(method={"doTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;getFoodLevel()I", ordinal=3)})
    private void injectDoTickWith(CallbackInfo ci) {
        if (this.getThirstData().getThirstLevel() != this.lastRecordedThirstLevel) {
            this.lastRecordedThirstLevel = this.getThirstData().getThirstLevel();
        }
    }
}

