/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuuki14202028.minecraft.thirst.thirst;

import com.github.yuuki14202028.minecraft.thirst.thirst.ThirstProperties;
import com.github.yuuki14202028.minecraft.thirst.thirst.interfaces.ItemAdditionalData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0004J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/github/yuuki14202028/minecraft/thirst/thirst/ThirstData;", "", "()V", "<set-?>", "", "exhaustionLevel", "getExhaustionLevel", "()F", "", "lastThirstLevel", "getLastThirstLevel", "()I", "saturationLevel", "getSaturationLevel", "thirstLevel", "getThirstLevel", "setThirstLevel", "(I)V", "tickTimer", "addAdditionalSaveData", "", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "addExhaustion", "amount", "drink", "item", "Lnet/minecraft/world/item/Item;", "stack", "Lnet/minecraft/world/item/ItemStack;", "needsThirst", "", "readAdditionalSaveData", "setExhaustion", "setSaturation", "tick", "player", "Lnet/minecraft/world/entity/player/Player;", "thirst"})
public final class ThirstData {
    private int thirstLevel = 20;
    private float saturationLevel = 5.0f;
    private float exhaustionLevel;
    private int tickTimer;
    private int lastThirstLevel = 20;

    public final int getThirstLevel() {
        return this.thirstLevel;
    }

    public final void setThirstLevel(int n) {
        this.thirstLevel = n;
    }

    public final float getSaturationLevel() {
        return this.saturationLevel;
    }

    public final float getExhaustionLevel() {
        return this.exhaustionLevel;
    }

    public final int getLastThirstLevel() {
        return this.lastThirstLevel;
    }

    public final void drink(int thirstLevel, float saturationLevel) {
        this.thirstLevel = RangesKt.coerceAtMost((int)(thirstLevel + this.thirstLevel), (int)20);
        this.saturationLevel = RangesKt.coerceAtMost((float)(this.saturationLevel + (float)thirstLevel * saturationLevel * 2.0f), (float)this.thirstLevel);
    }

    public final void drink(@NotNull Item item, @Nullable ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (((ItemAdditionalData)item).isDrinkable()) {
            ThirstProperties thirstProperties = ((ItemAdditionalData)item).getThirstProperties();
            Intrinsics.checkNotNull((Object)thirstProperties);
            ThirstProperties thirstProperties2 = thirstProperties;
            Intrinsics.checkNotNullExpressionValue((Object)thirstProperties2, (String)"item.thirstProperties!!");
            ThirstProperties thirstProperties3 = thirstProperties2;
            this.drink(thirstProperties3.getHydration(), thirstProperties3.getSaturationModifier());
        }
    }

    public final void tick(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Difficulty difficulty = player.f_19853_.m_46791_();
        this.lastThirstLevel = this.thirstLevel;
        if (this.exhaustionLevel > 4.0f) {
            this.exhaustionLevel -= 4.0f;
            if (this.saturationLevel > 0.0f) {
                this.saturationLevel = RangesKt.coerceAtLeast((float)(this.saturationLevel - 1.0f), (float)0.0f);
            } else if (difficulty != Difficulty.PEACEFUL) {
                this.thirstLevel = RangesKt.coerceAtLeast((int)(this.thirstLevel - 1), (int)0);
            }
        }
        boolean flag = player.f_19853_.m_46469_().m_46207_(GameRules.f_46139_);
        if (this.thirstLevel <= 0) {
            ++this.tickTimer;
            if (this.tickTimer >= 80) {
                if (player.m_21223_() > 10.0f || difficulty == Difficulty.HARD || player.m_21223_() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.m_6469_(DamageSource.f_19313_, 1.0f);
                }
                this.tickTimer = 0;
            }
        }
    }

    public final void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        if (nbt.m_128425_("thirstLevel", 99)) {
            this.thirstLevel = nbt.m_128451_("thirstLevel");
            this.tickTimer = nbt.m_128451_("thirstTickTimer");
            this.saturationLevel = nbt.m_128457_("thirstSaturationLevel");
            this.exhaustionLevel = nbt.m_128457_("thirstExhaustionLevel");
        }
    }

    public final void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.m_128405_("thirstLevel", this.thirstLevel);
        nbt.m_128405_("thirstTickTimer", this.tickTimer);
        nbt.m_128350_("thirstSaturationLevel", this.saturationLevel);
        nbt.m_128350_("thirstExhaustionLevel", this.exhaustionLevel);
    }

    public final boolean needsThirst() {
        return this.thirstLevel < 20;
    }

    public final void addExhaustion(float amount) {
        this.exhaustionLevel = Math.min(this.exhaustionLevel + amount, 40.0f);
    }

    public final void setSaturation(float amount) {
        this.saturationLevel = amount;
    }

    public final void setExhaustion(float amount) {
        this.exhaustionLevel = amount;
    }
}

