/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuuki14202028.minecraft.thirst.thirst.mixins;

import com.github.yuuki14202028.minecraft.thirst.thirst.ThirstData;
import com.github.yuuki14202028.minecraft.thirst.thirst.interfaces.PlayerAdditionalData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerAdditionalData {
    @Shadow
    @Final
    private Abilities f_36077_;
    @Shadow
    protected FoodData f_36097_;
    private ThirstData thirstDataImpl = new ThirstData();

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public ThirstData getThirstData() {
        return this.thirstDataImpl;
    }

    @Override
    public void setThirstData(ThirstData data) {
        this.thirstDataImpl = data;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;tick(Lnet/minecraft/world/entity/player/Player;)V")})
    private void injectTick(CallbackInfo ci) {
        this.getThirstData().tick((Player)this);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")})
    private void injectReadAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        this.getThirstData().readAdditionalSaveData(nbt);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")})
    private void injectAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        this.getThirstData().addAdditionalSaveData(nbt);
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private void injectEat(Level level, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        this.getThirstData().drink(stack.m_41720_(), stack);
    }

    @Redirect(method={"checkMovementStatistics"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"))
    private void injectCheckMovementStatistics(Player instance, float amount) {
        if (!this.f_36077_.f_35934_ && !this.f_19853_.f_46443_) {
            this.thirstDataImpl.addExhaustion(amount * 1.5f);
        }
    }

    @Redirect(method={"jumpFromGround"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;jumpFromGround()V"))
    private void injectJumpFromGround(LivingEntity instance) {
        double d0 = (double)this.m_6118_() + this.m_182332_();
        if (this.f_36097_.m_38702_() <= 6) {
            d0 *= 0.75;
        }
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, d0, vec3.f_82481_);
        if (this.m_20142_()) {
            float f = this.m_146908_() * ((float)Math.PI / 180);
            this.m_20256_(this.m_20184_().m_82520_((double)(-Mth.m_14031_((float)f) * 0.2f), 0.0, (double)(Mth.m_14089_((float)f) * 0.2f)));
        }
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
    }

    @Redirect(method={"jumpFromGround"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"))
    private void injectJumpFromGround(Player instance, float amount) {
        if (!this.f_36077_.f_35934_ && !this.f_19853_.f_46443_) {
            this.thirstDataImpl.addExhaustion(amount * 2.0f);
        }
    }
}

