/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.aceswildwestdimension.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.aceswildwestdimension.world.features.AbandonedHomesteadFeature;
import net.mcreator.aceswildwestdimension.world.features.AncientMissionFeature;
import net.mcreator.aceswildwestdimension.world.features.DesertFortStructureFeature;
import net.mcreator.aceswildwestdimension.world.features.JoshuaTree1Feature;
import net.mcreator.aceswildwestdimension.world.features.LushCactiFeature;
import net.mcreator.aceswildwestdimension.world.features.Town1Feature;
import net.mcreator.aceswildwestdimension.world.features.Town2Feature;
import net.mcreator.aceswildwestdimension.world.features.ores.BrownSandFeature;
import net.mcreator.aceswildwestdimension.world.features.ores.GunpowderOreFeature;
import net.mcreator.aceswildwestdimension.world.features.ores.SageFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class AceSWildWestDimensionModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"ace_s_wild_west_dimension");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> BROWN_SAND = AceSWildWestDimensionModFeatures.register("brown_sand", BrownSandFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, BrownSandFeature.GENERATE_BIOMES, BrownSandFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SAGE = AceSWildWestDimensionModFeatures.register("sage", SageFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, SageFeature.GENERATE_BIOMES, SageFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GUNPOWDER_ORE = AceSWildWestDimensionModFeatures.register("gunpowder_ore", GunpowderOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, GunpowderOreFeature.GENERATE_BIOMES, GunpowderOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> ABANDONED_HOMESTEAD = AceSWildWestDimensionModFeatures.register("abandoned_homestead", AbandonedHomesteadFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, AbandonedHomesteadFeature.GENERATE_BIOMES, AbandonedHomesteadFeature::placedFeature));
    public static final RegistryObject<Feature<?>> ANCIENT_MISSION = AceSWildWestDimensionModFeatures.register("ancient_mission", AncientMissionFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, AncientMissionFeature.GENERATE_BIOMES, AncientMissionFeature::placedFeature));
    public static final RegistryObject<Feature<?>> JOSHUA_TREE_1 = AceSWildWestDimensionModFeatures.register("joshua_tree_1", JoshuaTree1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, JoshuaTree1Feature.GENERATE_BIOMES, JoshuaTree1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> LUSH_CACTI = AceSWildWestDimensionModFeatures.register("lush_cacti", LushCactiFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, LushCactiFeature.GENERATE_BIOMES, LushCactiFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TOWN_1 = AceSWildWestDimensionModFeatures.register("town_1", Town1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Town1Feature.GENERATE_BIOMES, Town1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> DESERT_FORT_STRUCTURE = AceSWildWestDimensionModFeatures.register("desert_fort_structure", DesertFortStructureFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, DesertFortStructureFeature.GENERATE_BIOMES, DesertFortStructureFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TOWN_2 = AceSWildWestDimensionModFeatures.register("town_2", Town2Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Town2Feature.GENERATE_BIOMES, Town2Feature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

