/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.client;

import com.milamber_brass.brass_armory.BrassArmory;
import com.milamber_brass.brass_armory.client.render.BAArrowRenderer;
import com.milamber_brass.brass_armory.client.render.BombEntityRenderer;
import com.milamber_brass.brass_armory.client.render.BoomerangEntityRenderer;
import com.milamber_brass.brass_armory.client.render.SpearEntityRenderer;
import com.milamber_brass.brass_armory.entity.bomb.BombEntity;
import com.milamber_brass.brass_armory.entity.bomb.BombType;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.BombItem;
import com.milamber_brass.brass_armory.item.HalberdItem;
import com.milamber_brass.brass_armory.item.SpearItem;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="brass_armory", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventBusSubscriber {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        BrassArmory.LOGGER.debug("Running client setup.");
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.SPEAR.get()), SpearEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.BA_ARROW.get()), BAArrowRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.BOMB.get()), BombEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.BOUNCY_BOMB.get()), BombEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.STICKY_BOMB.get()), BombEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.BOOMERANG.get()), BoomerangEntityRenderer::new);
        event.enqueueWork(() -> {
            SpearItem[] spears;
            HalberdItem[] halberds;
            for (BombType bombType : BombType.values()) {
                ItemProperties.register((Item)BombType.getBombItem(bombType), (ResourceLocation)new ResourceLocation("bomb_fuse"), (bombStack, clientLevel, living, k) -> {
                    LivingEntity entity;
                    Object object = entity = living != null ? living : bombStack.m_41609_();
                    if (!BombItem.getFuseLit(bombStack) || entity == null) {
                        return 1.0f;
                    }
                    if (clientLevel == null && entity.f_19853_ instanceof ClientLevel) {
                        clientLevel = (ClientLevel)entity.f_19853_;
                    }
                    if (clientLevel == null || !(bombStack.m_41720_() instanceof BombItem)) {
                        return 1.0f;
                    }
                    return (float)BombItem.getFuseLength(bombStack) / 60.0f;
                });
                ItemProperties.register((Item)BombType.getBombItem(bombType), (ResourceLocation)new ResourceLocation("defused"), (bombStack, clientLevel, living, k) -> {
                    BombEntity bomb;
                    LivingEntity entity = living != null ? living : bombStack.m_41609_();
                    return entity instanceof BombEntity && (bomb = (BombEntity)entity).getDefused() ? 1.0f : 0.0f;
                });
            }
            for (HalberdItem halberdItem : halberds = new HalberdItem[]{(HalberdItem)BrassArmoryItems.WOOD_HALBERD.get(), (HalberdItem)BrassArmoryItems.STONE_HALBERD.get(), (HalberdItem)BrassArmoryItems.IRON_HALBERD.get(), (HalberdItem)BrassArmoryItems.GOLD_HALBERD.get(), (HalberdItem)BrassArmoryItems.DIAMOND_HALBERD.get(), (HalberdItem)BrassArmoryItems.NETHERITE_HALBERD.get()}) {
                ItemProperties.register((Item)halberdItem, (ResourceLocation)new ResourceLocation("blocking"), (halberdStack, clientLevel, living, k) -> living != null && living.m_6117_() && living.m_21211_() == halberdStack ? 1.0f : 0.0f);
            }
            for (SpearItem spearItem : spears = new SpearItem[]{(SpearItem)BrassArmoryItems.WOOD_SPEAR.get(), (SpearItem)BrassArmoryItems.STONE_SPEAR.get(), (SpearItem)BrassArmoryItems.IRON_SPEAR.get(), (SpearItem)BrassArmoryItems.GOLD_SPEAR.get(), (SpearItem)BrassArmoryItems.DIAMOND_SPEAR.get(), (SpearItem)BrassArmoryItems.NETHERITE_SPEAR.get()}) {
                ItemProperties.register((Item)spearItem, (ResourceLocation)new ResourceLocation("throwing"), (spearStack, clientLevel, living, k) -> living != null && living.m_6117_() && living.m_21211_() == spearStack ? 1.0f : 0.0f);
            }
        });
    }
}

