/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.bomb;

import com.milamber_brass.brass_armory.entity.bomb.BombType;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BombEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Integer> DATA_FUSE = SynchedEntityData.m_135353_(BombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_RENDER_ROTATION = SynchedEntityData.m_135353_(BombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float rotDirection;
    private int hitPerTick;
    private boolean defused;

    public BombEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
        this.setFuse(60);
        this.m_6853_(false);
        this.rotDirection = -10.0f;
        this.defused = false;
    }

    public BombEntity(Level level, LivingEntity livingEntity, @Nullable HumanoidArm arm) {
        super((EntityType)BrassArmoryEntityTypes.BOMB.get(), livingEntity, level);
        this.setFuse(60);
        this.m_6853_(false);
        this.rotDirection = arm == HumanoidArm.LEFT ? 10.0f : -10.0f;
        this.defused = false;
    }

    public BombEntity(Level level, double x, double y, double z) {
        super((EntityType)BrassArmoryEntityTypes.BOMB.get(), x, y, z, level);
        this.setFuse(60);
        this.m_6853_(false);
        this.rotDirection = -10.0f;
        this.defused = false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FUSE, (Object)80);
        this.f_19804_.m_135372_(DATA_RENDER_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected BombType getBombType() {
        return BombType.NORMAL;
    }

    @NotNull
    protected Item m_7881_() {
        return BombType.getBombItem(this.getBombType());
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.setRotation(this.getRotation() + this.rotDirection * (float)this.m_20184_().m_82553_());
        }
        this.hitPerTick = 0;
        super.m_8119_();
        int newFuse = this.getFuse() - (this.m_6060_() ? 2 : 1);
        this.setFuse(newFuse);
        if (newFuse <= 0) {
            this.m_146870_();
            if (!this.defused && !this.f_19853_.f_46443_) {
                BombEntity.explode(this.f_19853_, (Entity)this);
            }
        }
        if (this.m_20096_()) {
            this.onGroundTick();
        }
        if (!this.defused) {
            if (this.f_19853_.f_46443_ && this.f_19853_.m_5822_().nextInt(2) == 1) {
                Vec3 smokeVec = this.m_20182_().m_82549_(this.m_20184_().m_82542_(-1.5, -1.5, -1.5)).m_82520_(0.0, 0.125, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, smokeVec.f_82479_, smokeVec.f_82480_, smokeVec.f_82481_, 0.0, 0.0, 0.0);
            }
            this.m_5496_((SoundEvent)BrassArmorySounds.BOMB_FUSE.get(), 0.03f, this.f_19853_.m_5822_().nextFloat() * 0.6f + 1.0f);
            if (this.m_20072_()) {
                this.setFuse(40);
                this.defused = true;
            }
        }
    }

    protected void onGroundTick() {
        this.setRotation(this.getRotation() + this.rotDirection * (float)this.m_20184_().m_82553_() * (this.m_20072_() ? 4.0f : 16.0f));
        Vec3 vec = this.m_20184_();
        boolean flag = this.m_20229_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        this.m_20256_(vec.m_82542_(0.96, flag ? 1.0 : 0.0, 0.96));
        this.m_6853_(!flag);
    }

    public void m_20093_() {
        this.explode(this.f_19853_);
    }

    @ParametersAreNonnullByDefault
    public void m_8038_(ServerLevel serverLevel, LightningBolt lightningBolt) {
        this.explode(this.f_19853_);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41619_() && !this.defused) {
            player.m_21008_(hand, this.m_7846_());
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6087_() {
        return true;
    }

    @ParametersAreNonnullByDefault
    protected void m_6532_(HitResult hitResult) {
        if (this.hitPerTick == 0) {
            this.onHitEffects();
        }
        if (++this.hitPerTick > 8) {
            this.explode(this.f_19853_);
            return;
        }
        this.bombOnHit(hitResult);
        this.rotDirection -= (float)this.m_20184_().m_82553_() * 2.0f;
    }

    protected void bombOnHit(HitResult hitResult) {
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            double bounceMultiplier = this.getBombType().getBounceMultiplier();
            Direction.Axis axis = blockHitResult.m_82434_().m_122434_();
            Vec3 movement = BombEntity.bounce(this.m_20184_(), axis, bounceMultiplier);
            this.m_20256_(movement);
            HitResult newHitResult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
            if (newHitResult.m_6662_() != HitResult.Type.MISS) {
                this.m_6532_(newHitResult);
            } else if (movement.f_82480_ < 0.05 && blockHitResult.m_82434_() == Direction.UP) {
                this.m_6853_(true);
                this.m_20334_(movement.f_82479_, 0.0, movement.f_82481_);
            }
        }
    }

    public static Vec3 bounce(Vec3 deltaMovement, Direction.Axis axis, double multiplier) {
        double newX = deltaMovement.f_82479_ * (axis.equals((Object)Direction.Axis.X) ? -1.0 : 1.0) * multiplier;
        double newY = deltaMovement.f_82480_ * (axis.equals((Object)Direction.Axis.Y) ? -1.0 : 1.0) * multiplier;
        double newZ = deltaMovement.f_82481_ * (axis.equals((Object)Direction.Axis.Z) ? -1.0 : 1.0) * multiplier;
        return new Vec3(newX, newY, newZ);
    }

    protected void onHitEffects() {
        float volume = (float)this.m_20184_().m_82553_() / this.getBombType().getVolumeMultiplier();
        this.m_5496_(this.getSoundEvent(), volume, ((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f) / 0.8f);
    }

    protected SoundEvent getSoundEvent() {
        return (SoundEvent)BrassArmorySounds.BOMB_HIT.get();
    }

    public double m_6049_() {
        return 0.25;
    }

    private void explode(Level level) {
        this.m_146870_();
        if (!level.f_46443_) {
            BombEntity.explode(level, (Entity)this);
        }
    }

    public static void explode(Level level, Entity victim) {
        Entity bomb;
        Object object = bomb = victim instanceof BombEntity ? victim : null;
        if (bomb != null && bomb.m_20202_() != null) {
            victim = bomb.m_20202_();
        }
        level.m_46511_(bomb, victim.m_20185_(), victim.m_20186_() + (double)(victim.m_20192_() * 0.5f), victim.m_20189_(), 2.0f, Explosion.BlockInteraction.BREAK);
    }

    public void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128376_("Fuse", (short)this.getFuse());
    }

    public void m_7378_(CompoundTag compoundTag) {
        this.setFuse(compoundTag.m_128448_("Fuse"));
    }

    public void setFuse(int newFuse) {
        this.f_19804_.m_135381_(DATA_FUSE, (Object)newFuse);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE);
    }

    public void setRotation(float newRotation) {
        this.f_19804_.m_135381_(DATA_RENDER_ROTATION, (Object)Float.valueOf(newRotation));
    }

    public float getRotation() {
        return ((Float)this.f_19804_.m_135370_(DATA_RENDER_ROTATION)).floatValue();
    }

    public boolean getDefused() {
        return this.defused;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

