/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.bomb;

import com.milamber_brass.brass_armory.entity.bomb.BombEntity;
import com.milamber_brass.brass_armory.entity.bomb.BouncyBombEntity;
import com.milamber_brass.brass_armory.entity.bomb.StickyBombEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.BombItem;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public enum BombType {
    NORMAL(0.3, 0.2f),
    BOUNCY(1.0, 1.1f),
    STICKY(0.0, 0.9f);

    private final double bounceMultiplier;
    private final float volumeMultiplier;

    private BombType(double bounceMultiplier, float volumeMultiplier) {
        this.bounceMultiplier = bounceMultiplier;
        this.volumeMultiplier = volumeMultiplier;
    }

    public double getBounceMultiplier() {
        return this.bounceMultiplier;
    }

    public float getVolumeMultiplier() {
        return this.volumeMultiplier;
    }

    public static Item getBombItem(BombType bombType) {
        return switch (bombType) {
            case NORMAL -> (BombItem)BrassArmoryItems.BOMB.get();
            case BOUNCY -> (BombItem)BrassArmoryItems.BOUNCY_BOMB.get();
            default -> (BombItem)BrassArmoryItems.STICKY_BOMB.get();
        };
    }

    public static BombEntity playerBombEntityFromType(BombType bombType, Level level, Player player, HumanoidArm humanoidarm) {
        return switch (bombType) {
            case NORMAL -> new BombEntity(level, (LivingEntity)player, humanoidarm);
            case BOUNCY -> new BouncyBombEntity(level, (LivingEntity)player, humanoidarm);
            default -> new StickyBombEntity(level, (LivingEntity)player, humanoidarm);
        };
    }

    public static BombEntity vec3BombEntityFromType(BombType bombType, Level level, double x, double y, double z) {
        return switch (bombType) {
            case NORMAL -> new BombEntity(level, x, y, z);
            case BOUNCY -> new BouncyBombEntity(level, x, y, z);
            default -> new StickyBombEntity(level, x, y, z);
        };
    }
}

