/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractThrownWeaponEntity
extends AbstractArrow
implements ItemSupplier {
    protected static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(AbstractThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Byte> DATA_LOYALTY_LEVEL = SynchedEntityData.m_135353_(AbstractThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Float> DATA_DAMAGE_VALUE = SynchedEntityData.m_135353_(AbstractThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected float power;
    protected boolean dealtDamage;

    protected AbstractThrownWeaponEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    protected AbstractThrownWeaponEntity(EntityType<? extends AbstractArrow> entityType, double x, double y, double z, Level level, ItemStack weaponStack) {
        super(entityType, x, y, z, level);
        this.setItem(weaponStack);
        double damage = 0.0;
        for (AttributeModifier attributeModifier : weaponStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
            damage += attributeModifier.m_22218_();
        }
        this.f_19804_.m_135381_(DATA_DAMAGE_VALUE, (Object)Float.valueOf((float)damage));
    }

    protected AbstractThrownWeaponEntity(EntityType<? extends AbstractArrow> entityType, LivingEntity living, Level level, ItemStack weaponStack) {
        super(entityType, living, level);
        this.setItem(weaponStack);
        double damage = living.m_21133_(Attributes.f_22281_);
        ItemStack mainHandItem = living.m_21205_();
        if (mainHandItem != weaponStack) {
            if (!mainHandItem.m_41619_()) {
                for (AttributeModifier attributeModifier : mainHandItem.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
                    damage -= attributeModifier.m_22218_();
                }
            }
            for (AttributeModifier attributeModifier : weaponStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
                damage += attributeModifier.m_22218_();
            }
        }
        this.f_19804_.m_135381_(DATA_DAMAGE_VALUE, (Object)Float.valueOf((float)damage));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_LOYALTY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(DATA_DAMAGE_VALUE, (Object)Float.valueOf(1.0f));
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        this.loyaltyTick();
        super.m_8119_();
    }

    protected void loyaltyTick() {
        Entity entity = this.m_37282_();
        double loyaltyLevel = ((Byte)this.f_19804_.m_135370_(DATA_LOYALTY_LEVEL)).byteValue();
        if (loyaltyLevel > 0.0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!(!entity.m_6084_() || entity instanceof ServerPlayer && entity.m_5833_())) {
                this.m_36790_(true);
                Vec3 deltaDifference = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + deltaDifference.f_82480_ * 0.015 * loyaltyLevel, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(deltaDifference.m_82541_().m_82490_(0.05 * loyaltyLevel)));
            } else {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
    }

    @Nullable
    @ParametersAreNonnullByDefault
    protected EntityHitResult m_6351_(Vec3 pointOne, Vec3 pointTwo) {
        Entity entity;
        EntityHitResult result = super.m_6351_(pointOne, pointTwo);
        if (result != null && (entity = result.m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.f_20916_ > 0 ? null : super.m_6351_(pointOne, pointTwo);
        }
        return super.m_6351_(pointOne, pointTwo);
    }

    @ParametersAreNonnullByDefault
    protected void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity livingVictim;
        Entity victimEntity = entityHitResult.m_82443_();
        Entity ownerEntity = this.m_37282_();
        float damage = ((Float)this.f_19804_.m_135370_(DATA_DAMAGE_VALUE)).floatValue();
        if (victimEntity instanceof LivingEntity) {
            livingVictim = (LivingEntity)victimEntity;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.m_7846_(), (MobType)livingVictim.m_6336_());
        }
        if (this.m_36792_()) {
            damage *= 1.5f;
        }
        this.dealtDamage = true;
        if (victimEntity.m_6469_(new IndirectEntityDamageSource(this.onHitDamageSource(), (Entity)this, (Entity)(ownerEntity == null ? this : ownerEntity)).m_19366_(), damage *= this.getPower())) {
            if (victimEntity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (victimEntity instanceof LivingEntity) {
                livingVictim = (LivingEntity)victimEntity;
                if (ownerEntity instanceof LivingEntity) {
                    LivingEntity livingOwner = (LivingEntity)ownerEntity;
                    EnchantmentHelper.m_44823_((LivingEntity)livingVictim, (Entity)livingOwner);
                    EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)livingVictim);
                }
                this.m_7761_(livingVictim);
            }
        }
        this.m_20256_(this.onHitDeltaMovement());
        this.m_5496_(this.onHitSoundEvent(), 1.0f, 1.0f);
    }

    protected abstract String onHitDamageSource();

    protected Vec3 onHitDeltaMovement() {
        return this.m_20184_().m_82542_(-0.01, -0.1, -0.01);
    }

    protected abstract SoundEvent onHitSoundEvent();

    @ParametersAreNonnullByDefault
    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    @Nonnull
    protected abstract SoundEvent m_7239_();

    @ParametersAreNonnullByDefault
    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_37282_() == null) {
            super.m_6123_(player);
        }
    }

    protected abstract Item getDefaultItem();

    protected ItemStack getItemRaw() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ITEM_STACK);
    }

    @Nonnull
    protected ItemStack m_7941_() {
        return this.m_7846_();
    }

    @ParametersAreNonnullByDefault
    public void setItem(ItemStack weaponStack) {
        this.f_19804_.m_135381_(DATA_LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)weaponStack)));
        if (!weaponStack.m_150930_(this.getDefaultItem()) || weaponStack.m_41782_()) {
            this.f_19804_.m_135381_(DATA_ITEM_STACK, (Object)((ItemStack)Util.m_137469_((Object)weaponStack.m_41777_(), itemStack -> itemStack.m_41764_(1))));
        }
    }

    @Nonnull
    public ItemStack m_7846_() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    public void setPower(float power) {
        this.power = power;
    }

    public float getPower() {
        return this.power;
    }

    @ParametersAreNonnullByDefault
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        ItemStack weaponStack = this.getItemRaw();
        if (!weaponStack.m_41619_()) {
            compoundTag.m_128365_("WeaponStack", (Tag)weaponStack.m_41739_(new CompoundTag()));
        }
        compoundTag.m_128379_("DealtDamage", this.dealtDamage);
        compoundTag.m_128350_("ThrownWeaponDamage", ((Float)this.f_19804_.m_135370_(DATA_DAMAGE_VALUE)).floatValue());
        compoundTag.m_128350_("ThrownWeaponPower", this.getPower());
    }

    @ParametersAreNonnullByDefault
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setItem(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("WeaponStack")));
        this.dealtDamage = compoundTag.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(DATA_DAMAGE_VALUE, (Object)Float.valueOf(compoundTag.m_128457_("ThrownWeaponDamage")));
        this.setPower(compoundTag.m_128457_("ThrownWeaponPower"));
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

