/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.milamber_brass.brass_armory.entity.bomb.BombEntity;
import com.milamber_brass.brass_armory.entity.bomb.BombType;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class BombItem
extends Item {
    private final BombType bombType;

    public BombItem(Item.Properties properties, BombType bombType) {
        super(properties);
        this.bombType = bombType;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack bombStack = player.m_21120_(interactionHand);
        if (!BombItem.getFuseLit(bombStack)) {
            if (!player.m_5842_()) {
                BombItem.setFuseLit(bombStack, true);
                BombItem.setFuseLength(bombStack, 60);
                player.m_36335_().m_41524_(bombStack.m_41720_(), 5);
                player.m_5496_((SoundEvent)BrassArmorySounds.BOMB_LIT.get(), 0.9f, level.m_5822_().nextFloat() * 0.4f + 0.7f);
                player.m_146850_(GameEvent.f_157776_);
            }
        } else {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)BrassArmorySounds.BOMB_THROW.get(), SoundSource.PLAYERS, 0.5f, 0.4f / (level.m_5822_().nextFloat() * 0.4f + 0.8f));
            this.throwBomb(level, player, interactionHand, bombStack, 0.75f);
        }
        return InteractionResultHolder.m_19092_((Object)bombStack, (boolean)level.m_5776_());
    }

    private void throwBomb(Level level, Player player, InteractionHand interactionHand, ItemStack bombStack, float power) {
        if (!level.f_46443_) {
            boolean mainHandFlag = interactionHand == InteractionHand.MAIN_HAND;
            HumanoidArm humanoidarm = mainHandFlag ? player.m_5737_() : player.m_5737_().m_20828_();
            BombEntity bomb = BombType.playerBombEntityFromType(this.bombType, level, player, humanoidarm);
            bomb.m_37446_(bombStack);
            bomb.setFuse(BombItem.getFuseLength(bombStack));
            bomb.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power, 0.25f);
            level.m_7967_((Entity)bomb);
            if (bombStack.m_41613_() > 1 || player.m_150110_().f_35937_) {
                BombItem.setFuseLit(bombStack, false);
                BombItem.setFuseLength(bombStack, 60);
            }
        }
        if (!player.m_150110_().f_35937_) {
            bombStack.m_41774_(1);
            player.m_36335_().m_41524_(bombStack.m_41720_(), 20);
        }
    }

    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack bombStack, Level level, Entity entity, int i, boolean b) {
        block5: {
            block2: {
                block3: {
                    block4: {
                        if (!BombItem.getFuseLit(bombStack)) break block2;
                        if (level.f_46443_) break block3;
                        int fuse = BombItem.getFuseLength(bombStack) - 1;
                        BombItem.setFuseLength(bombStack, fuse);
                        if (fuse > 0) break block3;
                        BombEntity.explode(level, entity);
                        BombItem.setFuseLit(bombStack, false);
                        BombItem.setFuseLength(bombStack, 60);
                        if (!(entity instanceof Player)) break block4;
                        Player player = (Player)entity;
                        if (player.m_150110_().f_35937_) break block3;
                    }
                    bombStack.m_41774_(1);
                }
                entity.m_5496_((SoundEvent)BrassArmorySounds.BOMB_FUSE.get(), 0.03f, level.m_5822_().nextFloat() * 0.6f + 1.0f);
                break block5;
            }
            BombItem.setFuseLength(bombStack, 60);
        }
    }

    public boolean onDroppedByPlayer(ItemStack bombStack, Player player) {
        if (BombItem.getFuseLit(bombStack)) {
            this.throwBomb(player.m_183503_(), player, InteractionHand.MAIN_HAND, bombStack, 0.24f);
            return false;
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_41720_().equals(newStack.m_41720_());
    }

    public BombType getBombType() {
        return this.bombType;
    }

    public static void setFuseLength(ItemStack bombStack, int fuse) {
        bombStack.m_41784_().m_128405_("BrassArmoryFuseLength", Math.min(60, fuse));
    }

    public static int getFuseLength(ItemStack bombStack) {
        return bombStack.m_41784_().m_128451_("BrassArmoryFuseLength");
    }

    public static void setFuseLit(ItemStack bombStack, boolean fuseLit) {
        bombStack.m_41784_().m_128379_("BrassArmoryFuseLit", fuseLit);
    }

    public static boolean getFuseLit(ItemStack bombStack) {
        return bombStack.m_41784_().m_128471_("BrassArmoryFuseLit");
    }
}

