/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.milamber_brass.brass_armory.entity.projectile.BoomerangEntity;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.item.ICustomAnimationItem;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class BoomerangItem
extends TieredItem
implements Vanishable,
ICustomAnimationItem {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private final ImmutableSet<Enchantment> properEnchantments = ImmutableSet.of((Object)Enchantments.f_44955_, (Object)Enchantments.f_44990_, (Object)Enchantments.f_44960_, (Object)Enchantments.f_44957_);
    public static final String critTag = "BABoomerangCrit";
    public static final String timeTag = "BABoomerangTime";
    private static Field toolHighlightTimerField = null;

    public BoomerangItem(Tier tier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)((float)attackDamage + tier.m_6631_()), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack boomerangStack = player.m_21120_(interactionHand);
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)boomerangStack);
    }

    @ParametersAreNonnullByDefault
    public void m_5551_(ItemStack boomerangStack, Level level, LivingEntity livingEntity, int useDurationLeft) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float time = this.m_8105_(boomerangStack) - useDurationLeft;
            float power = Math.min(time / (float)this.getChargeDuration(boomerangStack), 1.0f);
            if ((double)power >= 0.1 && !level.f_46443_) {
                boomerangStack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(livingEntity.m_7655_()));
                boolean noGravity = power > 0.25f;
                BoomerangEntity boomerangEntity = new BoomerangEntity(level, (LivingEntity)player, boomerangStack);
                boomerangEntity.setPower(power);
                float xRot = livingEntity.m_146909_();
                float yRot = livingEntity.m_146908_();
                boomerangEntity.m_37251_((Entity)livingEntity, xRot, yRot, 0.0f, power, 1.0f);
                boomerangEntity.m_146926_(xRot);
                boomerangEntity.m_146922_(yRot);
                boomerangEntity.m_20242_(noGravity);
                boomerangEntity.m_36762_(level.f_46441_.nextFloat(100.0f) <= BoomerangItem.getCrit(boomerangStack));
                if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)boomerangStack) > 0) {
                    boomerangEntity.m_20254_(100);
                }
                level.m_7967_((Entity)boomerangEntity);
                level.m_6269_(null, (Entity)boomerangEntity, (SoundEvent)BrassArmorySounds.BOMB_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_150109_().m_36057_(boomerangStack);
            }
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public Component m_7626_(ItemStack boomerangStack) {
        int crit = (int)BoomerangItem.getCrit(boomerangStack);
        if (crit <= 0) {
            return super.m_7626_(boomerangStack);
        }
        return new TextComponent("Critical Strike: " + crit + "%").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(0xC80000 + (5 - crit / 20) * 10000));
    }

    @ParametersAreNonnullByDefault
    public boolean m_7579_(ItemStack boomerangStack, LivingEntity victim, LivingEntity player) {
        boomerangStack.m_41622_(3, player, living -> living.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean m_6813_(ItemStack boomerangStack, Level level, BlockState blockState, BlockPos pos, LivingEntity livingEntity) {
        if ((double)blockState.m_60800_((BlockGetter)level, pos) != 0.0) {
            boomerangStack.m_41622_(2, livingEntity, living -> living.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack boomerangStack, Level level, Entity entity, int i, boolean b) {
        float crit = BoomerangItem.getCrit(boomerangStack);
        if (crit > 0.0f && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            int drain = (int)Math.min(level.m_46467_() - BoomerangItem.getTime(boomerangStack), 1000L) / 20;
            if (!level.f_46443_ && drain > 0 && !living.m_6117_()) {
                boomerangStack.m_41784_().m_128350_(critTag, Math.max(crit - (float)drain, 0.0f));
            }
            if (level.f_46443_ && living.m_21205_() == boomerangStack) {
                if (toolHighlightTimerField == null) {
                    toolHighlightTimerField = ObfuscationReflectionHelper.findField(Gui.class, (String)"f_92993_");
                    toolHighlightTimerField.setAccessible(true);
                }
                try {
                    toolHighlightTimerField.set(Minecraft.m_91087_().f_91065_, 40);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        super.m_6883_(boomerangStack, level, entity, i, b);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || this.properEnchantments.contains((Object)enchantment);
    }

    @ParametersAreNonnullByDefault
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_41720_().equals(newStack.m_41720_()) || slotChanged;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public UseAnim m_6164_(ItemStack boomerangStack) {
        return UseAnim.SPEAR;
    }

    @ParametersAreNonnullByDefault
    public int m_8105_(ItemStack boomerangStack) {
        return 72000;
    }

    @Override
    @ParametersAreNonnullByDefault
    public int getCustomUseDuration(ItemStack boomerangStack, Player player) {
        return this.m_8105_(boomerangStack) - player.m_21212_();
    }

    @Override
    public int getChargeDuration(ItemStack boomerangStack) {
        int quickCharge = Math.min(EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)boomerangStack), 3);
        return quickCharge == 0 ? 24 : 24 - 4 * quickCharge;
    }

    @ParametersAreNonnullByDefault
    public static void setCrit(ItemStack boomerangStack, float crit, long time) {
        boomerangStack.m_41784_().m_128350_(critTag, Math.min(crit, 100.0f));
        boomerangStack.m_41784_().m_128356_(timeTag, time);
    }

    @ParametersAreNonnullByDefault
    public static float getCrit(ItemStack boomerangStack) {
        if (boomerangStack.m_41783_() != null && boomerangStack.m_41783_().m_128441_(critTag)) {
            return boomerangStack.m_41784_().m_128457_(critTag);
        }
        return 0.0f;
    }

    @ParametersAreNonnullByDefault
    public static long getTime(ItemStack boomerangStack) {
        if (boomerangStack.m_41783_() != null && boomerangStack.m_41783_().m_128441_(timeTag)) {
            return boomerangStack.m_41784_().m_128454_(timeTag);
        }
        return 0L;
    }
}

