/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.milamber_brass.brass_armory.item.ICustomAnimationItem;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;

public class MaceItem
extends SwordItem
implements ICustomAnimationItem {
    public MaceItem(Tiers tier, int attackDamageIn, Item.Properties builderIn) {
        super((Tier)tier, attackDamageIn, -3.2f, builderIn);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack maceStack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)maceStack);
    }

    @ParametersAreNonnullByDefault
    public void m_5551_(ItemStack maceStack, Level level, LivingEntity livingEntity, int useDurationLeft) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.m_8105_(maceStack) - livingEntity.m_21212_() >= this.getChargeDuration(maceStack)) {
                double pRange = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())).m_22135_();
                float partialTicks = Minecraft.m_91087_().m_91296_();
                Vec3 vec3 = player.m_20299_(partialTicks);
                Vec3 vec31 = player.m_20252_(partialTicks);
                Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * pRange, vec31.f_82480_ * pRange, vec31.f_82481_ * pRange);
                BlockHitResult blockHitResult = level.m_45547_(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                double distance = blockHitResult.m_82448_((Entity)player);
                BlockPos blockPos = blockHitResult.m_82425_();
                Vec3 vec = blockHitResult.m_82450_();
                if (blockHitResult.m_6662_() == HitResult.Type.MISS || distance > 6.904 || blockHitResult.m_82434_() != Direction.UP) {
                    return;
                }
                if (!level.f_46443_) {
                    boolean mainHand = player.m_7655_() == InteractionHand.MAIN_HAND;
                    ItemStack otherItemStack = player.m_21120_(mainHand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                    Item item = otherItemStack.m_41720_();
                    if (item instanceof MaceItem) {
                        MaceItem otherMace = (MaceItem)item;
                        otherMace.smash(player, level, vec, maceStack, otherItemStack);
                        otherItemStack.m_41622_(10, (LivingEntity)player, player1 -> player1.m_21190_(InteractionHand.MAIN_HAND));
                        otherItemStack.m_41622_(10, (LivingEntity)player, player1 -> player1.m_21190_(InteractionHand.OFF_HAND));
                    } else {
                        this.smash(player, level, vec, maceStack, null);
                        maceStack.m_41622_(10, (LivingEntity)player, player1 -> player1.m_21190_(player.m_7655_()));
                    }
                } else {
                    this.smashParticles(vec, level, blockPos);
                    level.m_6263_(player, vec.f_82479_, vec.f_82480_, vec.f_82481_, SoundEvents.f_11892_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    private void smash(Player player, Level level, Vec3 vec, ItemStack maceStack, @Nullable ItemStack otherMaceStack) {
        double x = vec.f_82479_;
        double y = vec.f_82480_;
        double z = vec.f_82481_;
        AABB aabb = new AABB(x, y, z, x + 1.0, y + 1.0, z + 1.0).m_82400_(8.0);
        List entitiesInRange = level.m_6443_(Entity.class, aabb, Entity::m_6084_);
        boolean otherMaceFlag = otherMaceStack != null;
        float maceDamage = ((MaceItem)maceStack.m_41720_()).m_43299_() * 1.5f;
        float otherMaceDamage = otherMaceFlag ? ((MaceItem)otherMaceStack.m_41720_()).m_43299_() * 1.5f : 0.0f;
        for (Entity entity : entitiesInRange) {
            TamableAnimal pet;
            if (entity == player || entity instanceof ItemEntity || entity instanceof TamableAnimal && (pet = (TamableAnimal)entity).m_142480_() == player) continue;
            double entityDistance = Math.sqrt(entity.m_20238_(vec));
            if (entityDistance <= 4.0) {
                float otherMaceEnchantment;
                float maceEnchantment;
                float seenPercent = Explosion.m_46064_((Vec3)vec, (Entity)entity);
                if (entity instanceof LivingEntity) {
                    maceEnchantment = EnchantmentHelper.m_44833_((ItemStack)maceStack, (MobType)((LivingEntity)entity).m_6336_());
                    otherMaceEnchantment = otherMaceFlag ? EnchantmentHelper.m_44833_((ItemStack)otherMaceStack, (MobType)((LivingEntity)entity).m_6336_()) : 0.0f;
                } else {
                    maceEnchantment = EnchantmentHelper.m_44833_((ItemStack)maceStack, (MobType)MobType.f_21640_);
                    otherMaceEnchantment = otherMaceFlag ? EnchantmentHelper.m_44833_((ItemStack)otherMaceStack, (MobType)MobType.f_21640_) : 0.0f;
                }
                float totalDMG = Math.max(maceDamage + maceEnchantment, otherMaceDamage + otherMaceEnchantment);
                float bonusDMG = Math.min(maceDamage + maceEnchantment, otherMaceDamage + otherMaceEnchantment) / 2.0f;
                float finalDMG = (totalDMG + bonusDMG) * seenPercent;
                if (finalDMG > 0.0f) {
                    entity.m_6469_(DamageSource.m_19344_((Player)player), (totalDMG + bonusDMG) * seenPercent);
                    player.m_5704_(entity);
                }
            }
            if (!(entityDistance <= 5.0) || !(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            living.m_147240_((double)0.1f * Math.abs(entityDistance - 5.0) + entityDistance > 4.0 ? (double)0.4f : 0.0, vec.f_82479_ - entity.m_20185_(), vec.f_82481_ - entity.m_20189_());
        }
        if (!player.m_150110_().f_35937_) {
            player.m_36335_().m_41524_(maceStack.m_41720_(), 600);
            if (otherMaceFlag) {
                player.m_36335_().m_41524_(otherMaceStack.m_41720_(), 600);
            }
        }
    }

    private void smashParticles(Vec3 vec, Level level, BlockPos blockPos) {
        for (int x = -6; x <= 6; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -6; z <= 6; ++z) {
                    BlockPos newPos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z);
                    Random r = level.m_5822_();
                    Vec3 newVec = new Vec3((double)newPos.m_123341_() + r.nextDouble(), (double)newPos.m_123342_() + 1.0 + r.nextDouble() * 2.0, (double)newPos.m_123343_() + r.nextDouble());
                    double newVecToVec = newVec.m_82554_(vec);
                    if (level.m_8055_(newPos).m_60795_() || !(newVecToVec <= 5.0)) continue;
                    for (int i = 0; i < r.nextInt((int)Math.abs(newVecToVec - 6.0) * 32); ++i) {
                        level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(new Vec3(0.98, 0.94, 0.9)), 0.8f), newVec.f_82479_, newVec.f_82480_, newVec.f_82481_, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public UseAnim m_6164_(ItemStack maceStack) {
        return UseAnim.SPEAR;
    }

    @ParametersAreNonnullByDefault
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public int m_8105_(ItemStack maceStack) {
        return 72000;
    }

    @Override
    @ParametersAreNonnullByDefault
    public int getCustomUseDuration(ItemStack maceStack, Player player) {
        return this.m_8105_(maceStack) - player.m_21212_();
    }

    @Override
    public int getChargeDuration(ItemStack itemStack) {
        return 30;
    }
}

