/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.milamber_brass.brass_armory.entity.projectile.SpearEntity;
import com.milamber_brass.brass_armory.item.ICustomReachItem;
import com.milamber_brass.brass_armory.item.ICustomTieredItem;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class SpearItem
extends TridentItem
implements Vanishable,
ICustomReachItem,
ICustomTieredItem {
    private static final float SPECIAL_REACH_MULTIPLIER = 1.5f;
    private final double reachDistanceBonus = 1.0;
    private final float attackDamage;
    private final Tier tier;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    private Multimap<Attribute, AttributeModifier> customAttributes;

    public SpearItem(Tier tier, int attackDamageIn, Item.Properties builderIn) {
        super(builderIn.m_41499_(tier.m_6609_()));
        this.attackDamage = (float)attackDamageIn + tier.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.6, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
        this.tier = tier;
    }

    public double getReach() {
        return this.reachDistanceBonus;
    }

    public double getReachExtended() {
        return this.reachDistanceBonus * 1.5;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    @ParametersAreNonnullByDefault
    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    @ParametersAreNonnullByDefault
    public float m_8102_(ItemStack stack, BlockState state) {
        Material material = state.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && material != Material.f_76301_ && !state.m_60620_((Tag)BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    @ParametersAreNonnullByDefault
    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @ParametersAreNonnullByDefault
    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerEntity = (Player)entityLiving;
            float time = this.m_8105_(stack) - timeLeft;
            if (time >= 5.0f) {
                if (!worldIn.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)playerEntity, player -> player.m_21190_(entityLiving.m_7655_()));
                    SpearEntity spear = new SpearEntity(worldIn, (LivingEntity)playerEntity, stack);
                    float power = Math.min(time / 20.0f, 1.0f);
                    spear.setPower(power);
                    spear.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, power * 1.2f, 1.0f);
                    if (playerEntity.m_150110_().f_35937_) {
                        spear.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    worldIn.m_7967_((Entity)spear);
                    worldIn.m_6269_(null, (Entity)spear, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!playerEntity.m_150110_().f_35937_) {
                        playerEntity.m_150109_().m_36057_(stack);
                    }
                }
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    @ParametersAreNonnullByDefault
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.m_60800_((BlockGetter)worldIn, pos) != 0.0) {
            stack.m_41622_(2, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && enchantment != Enchantments.f_44957_ && enchantment != Enchantments.f_44958_;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(equipmentSlot);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getCustomAttributesField() {
        return this.customAttributes;
    }

    @Override
    public void setCustomAttributesField(Multimap<Attribute, AttributeModifier> value) {
        this.customAttributes = value;
    }

    @Override
    @Nonnull
    public Multimap<Attribute, AttributeModifier> execSuperGetAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return ICustomReachItem.super.getAttributeModifiers(slot, stack);
    }

    @Override
    public double getReachDistanceBonus() {
        return 1.0;
    }
}

