/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.behaviour.ammo;

import com.milamber_brass.brass_armory.behaviour.ammo.AbstractAmmoBehaviour;
import com.milamber_brass.brass_armory.behaviour.iGun;
import com.milamber_brass.brass_armory.behaviour.powder.AbstractPowderBehaviour;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ThrownItemAmmoBehaviour
extends AbstractAmmoBehaviour {
    protected final BiFunction<Level, LivingEntity, ThrowableItemProjectile> newProjectileFunction;
    protected final Predicate<ItemStack> ammoItems;

    public ThrownItemAmmoBehaviour(Predicate<ItemStack> ammoItems, BiFunction<Level, LivingEntity, ThrowableItemProjectile> newProjectileFunction) {
        this.ammoItems = ammoItems;
        this.newProjectileFunction = newProjectileFunction;
    }

    @Override
    public boolean onShoot(Level level, LivingEntity owner, Entity shooter, ItemStack ammoStack, @Nullable AbstractPowderBehaviour powderBehaviour, iGun gun) {
        super.onShoot(level, owner, shooter, ammoStack, powderBehaviour, gun);
        ThrowableItemProjectile thrownItem = this.newProjectileFunction.apply(level, owner);
        if (powderBehaviour != null) {
            powderBehaviour.applyEffect((Entity)thrownItem);
        }
        if (!level.f_46443_) {
            thrownItem.m_37446_(ammoStack);
            float speed = gun.speed();
            thrownItem.m_146884_(shooter.m_146892_());
            thrownItem.m_37251_(shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, speed * 0.5f, gun.accuracy());
            gun.onShoot(level, owner, shooter, ammoStack, (Projectile)thrownItem);
            return level.m_7967_((Entity)thrownItem);
        }
        return true;
    }

    @Override
    @NotNull
    public Predicate<ItemStack> getAmmoItems() {
        return this.ammoItems;
    }
}

