/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.behaviour.powder;

import com.milamber_brass.brass_armory.behaviour.iGun;
import com.milamber_brass.brass_armory.init.BrassArmoryCapabilities;
import com.milamber_brass.brass_armory.init.BrassArmoryPackets;
import com.milamber_brass.brass_armory.packets.ParticlePacket;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public abstract class AbstractPowderBehaviour {
    protected final ParticleOptions particle;

    public AbstractPowderBehaviour(ParticleOptions particleOptions) {
        this.particle = particleOptions;
    }

    public void onShoot(Level level, LivingEntity owner, Entity shooter, ItemStack ammoStack, iGun gun) {
        if (!level.f_46443_) {
            Vec3 eyePosition = shooter.m_146892_();
            Vec3 viewVector = shooter.m_20252_(1.0f);
            ParticlePacket particlePacket = new ParticlePacket();
            for (double d = 0.0; d < (double)((int)(4.55f * gun.particleMultiplier())); d += 1.0) {
                for (int i = 0; i < (int)(8.0f * gun.particleMultiplier()); ++i) {
                    for (double o = 0.0; o < 1.0; o += 0.1) {
                        Vec3 vec32 = eyePosition.m_82520_(viewVector.f_82479_ * d + level.f_46441_.nextGaussian() * o, viewVector.f_82480_ * d + level.f_46441_.nextGaussian() * o, viewVector.f_82481_ * d + level.f_46441_.nextGaussian() * o).m_82549_(viewVector.m_82490_(gun.particleOffset()));
                        Vec3 particlePos = level.m_45547_(new ClipContext(eyePosition, vec32, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, shooter)).m_82450_();
                        particlePacket.queueParticle(this.particle, false, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                    }
                }
            }
            BrassArmoryPackets.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> shooter), (Object)particlePacket);
        }
    }

    public void sendParticles(ServerLevel serverLevel, Vec3 vec3) {
        if (this.getParticle() != null) {
            serverLevel.m_8767_(this.getParticle(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public ParticleOptions getParticle() {
        return this.particle;
    }

    public void applyEffect(Entity entity) {
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            projectile.getCapability(BrassArmoryCapabilities.POWDER_CAPABILITY).ifPresent(capability -> capability.setPowderBehaviour(this));
        }
    }

    @Nonnull
    public abstract Predicate<ItemStack> getPowderItems();
}

