/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
public class RopeBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty HAS_ARROW = BooleanProperty.m_61465_((String)"arrow");
    private static final VoxelShape ROPE_NORTH = Block.m_49796_((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape ROPE_SOUTH = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)4.0);
    private static final VoxelShape ROPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)16.0, (double)10.0);
    private static final VoxelShape ROPE_WEST = Block.m_49796_((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape ARROW_NORTH = Block.m_49796_((double)7.0, (double)12.0, (double)5.0, (double)9.0, (double)15.0, (double)16.0);
    private static final VoxelShape ARROW_SOUTH = Block.m_49796_((double)7.0, (double)12.0, (double)0.0, (double)9.0, (double)15.0, (double)11.0);
    private static final VoxelShape ARROW_EAST = Block.m_49796_((double)0.0, (double)12.0, (double)7.0, (double)11.0, (double)15.0, (double)9.0);
    private static final VoxelShape ARROW_WEST = Block.m_49796_((double)5.0, (double)12.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0);
    private static final VoxelShape NORTH_WITH_ARROW = Shapes.m_83110_((VoxelShape)ROPE_NORTH, (VoxelShape)ARROW_NORTH);
    private static final VoxelShape SOUTH_WITH_ARROW = Shapes.m_83110_((VoxelShape)ROPE_SOUTH, (VoxelShape)ARROW_SOUTH);
    private static final VoxelShape EAST_WITH_ARROW = Shapes.m_83110_((VoxelShape)ROPE_EAST, (VoxelShape)ARROW_EAST);
    private static final VoxelShape WEST_WITH_ARROW = Shapes.m_83110_((VoxelShape)ROPE_WEST, (VoxelShape)ARROW_WEST);

    public RopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)HAS_ARROW, (Comparable)Boolean.FALSE));
    }

    public static boolean canAttachTo(BlockGetter blockReader, BlockPos pos, Direction direction) {
        BlockState blockstate = blockReader.m_8055_(pos);
        return blockstate.m_60783_(blockReader, pos, direction);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, HAS_ARROW});
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> {
                if (((Boolean)state.m_61143_((Property)HAS_ARROW)).booleanValue()) {
                    yield NORTH_WITH_ARROW;
                }
                yield ROPE_NORTH;
            }
            case Direction.SOUTH -> {
                if (((Boolean)state.m_61143_((Property)HAS_ARROW)).booleanValue()) {
                    yield SOUTH_WITH_ARROW;
                }
                yield ROPE_SOUTH;
            }
            case Direction.EAST -> {
                if (((Boolean)state.m_61143_((Property)HAS_ARROW)).booleanValue()) {
                    yield EAST_WITH_ARROW;
                }
                yield ROPE_EAST;
            }
            default -> (Boolean)state.m_61143_((Property)HAS_ARROW) != false ? WEST_WITH_ARROW : ROPE_WEST;
        };
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (RopeBlock.canAttachTo((BlockGetter)worldIn, pos.m_142300_(direction.m_122424_()), direction)) {
            return true;
        }
        BlockState blockStateAbove = worldIn.m_8055_(pos.m_7494_());
        Block blockAbove = blockStateAbove.m_60734_();
        return blockAbove instanceof RopeBlock;
    }

    @Nonnull
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122424_() == stateIn.m_61143_((Property)FACING) && !stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return !this.m_7898_(stateIn, (LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate;
        if (!context.m_7058_() && (blockstate = context.m_43725_().m_8055_(context.m_8083_().m_142300_(context.m_43719_().m_122424_()))).m_60713_((Block)this) && blockstate.m_61143_((Property)FACING) == context.m_43719_()) {
            return null;
        }
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate1 = this.m_49966_();
        BlockState blockStateAbove = context.m_43725_().m_8055_(blockpos.m_7494_());
        Block blockAbove = blockStateAbove.m_60734_();
        if (blockAbove instanceof RopeBlock) {
            return (BlockState)blockstate1.m_61124_((Property)FACING, (Comparable)((Direction)blockStateAbove.m_61143_((Property)FACING)));
        }
        Level ilevelaccessor = context.m_43725_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockstate1 = (BlockState)blockstate1.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)ilevelaccessor, blockpos)) continue;
            return (BlockState)blockstate1.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

