/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.capabilities;

import com.milamber_brass.brass_armory.capabilities.IEffectCapability;
import com.milamber_brass.brass_armory.init.BrassArmoryCapabilities;
import com.milamber_brass.brass_armory.init.BrassArmoryPackets;
import com.milamber_brass.brass_armory.packets.EffectPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class EffectCapabilityHandler
implements IEffectCapability {
    private Player player;
    private double shake;
    private float slow;

    @Override
    public void setEntity(Player player) {
        this.player = player;
    }

    @Override
    public void setShake(double shake) {
        if (this.player instanceof ServerPlayer) {
            this.shake = shake;
            this.sendUpdatePacket();
        } else {
            this.shake = Math.max(this.shake, shake);
        }
    }

    @Override
    public void reduceShake(double d) {
        this.shake -= d;
        if (this.shake < 0.01) {
            this.shake = 0.0;
        }
    }

    @Override
    public double getShake() {
        return this.shake;
    }

    @Override
    public void setSlow(float slow) {
        this.slow = slow;
        if (!this.player.f_19853_.f_46443_) {
            this.sendUpdatePacket();
        }
    }

    @Override
    public float getSlow() {
        return this.slow;
    }

    @Override
    public void tick() {
        if (!this.player.f_19853_.f_46443_ && this.slow > 0.0f) {
            this.setSlow(Math.max(this.slow - 0.005f, 0.0f));
        }
    }

    private void sendUpdatePacket() {
        BrassArmoryPackets.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.player), (Object)new EffectPacket((Entity)this.player, (IEffectCapability)this));
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)Util.m_137469_((Object)new CompoundTag(), tag -> {
            tag.m_128347_("BAShakeValue", this.getShake());
            tag.m_128350_("BASlowValue", this.getSlow());
        });
    }

    public void deserializeNBT(CompoundTag tag) {
        this.setShake(tag.m_128459_("BAShakeValue"));
        this.setSlow(tag.m_128457_("BASlowValue"));
    }

    public static void setShakePower(Player player, double shake) {
        player.getCapability(BrassArmoryCapabilities.EFFECT_CAPABILITY).ifPresent(iShakeCapability -> iShakeCapability.setShake(shake));
    }
}

