/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity;

import com.milamber_brass.brass_armory.behaviour.GunBehaviours;
import com.milamber_brass.brass_armory.behaviour.iGun;
import com.milamber_brass.brass_armory.behaviour.powder.AbstractPowderBehaviour;
import com.milamber_brass.brass_armory.capabilities.EffectCapabilityHandler;
import com.milamber_brass.brass_armory.data.BrassArmoryTags;
import com.milamber_brass.brass_armory.init.BrassArmoryAdvancements;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.inventory.GunContainer;
import com.milamber_brass.brass_armory.item.CannonItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class CannonEntity
extends Entity
implements iGun {
    protected static final EntityDataAccessor<CompoundTag> DATA_TAG = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    protected static final EntityDataAccessor<Integer> DATA_FUSE = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> DATA_HURTDIR = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_HURT = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_MOVE_TICKS = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_SOUND_TICKS = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String uuid = "BAPlayerUUID";

    public CannonEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19850_ = true;
    }

    public CannonEntity(Level level, double x, double y, double z) {
        this((EntityType)BrassArmoryEntityTypes.CANNON.get(), level);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TAG, (Object)new CompoundTag());
        this.f_19804_.m_135372_(DATA_FUSE, (Object)0);
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_MOVE_TICKS, (Object)0);
        this.f_19804_.m_135372_(DATA_SOUND_TICKS, (Object)0);
    }

    public ItemStack getAmmo() {
        return ArmoryUtil.loadStack((CompoundTag)this.f_19804_.m_135370_(DATA_TAG), "BAAmmo", ItemStack.f_41583_);
    }

    @Override
    public void onOpen(Player owner, CompoundTag tag) {
        owner.f_19853_.m_6269_(null, (Entity)owner, (SoundEvent)BrassArmorySounds.CANNON_OPEN.get(), SoundSource.PLAYERS, 1.35f, this.f_19853_.m_5822_().nextFloat() * 0.35f + 0.235f);
    }

    @Override
    public void onLoad(Player owner, CompoundTag tag) {
        owner.f_19853_.m_6269_(null, (Entity)owner, (SoundEvent)BrassArmorySounds.CANNON_CLOSE.get(), SoundSource.PLAYERS, 1.5f, this.f_19853_.m_5822_().nextFloat() * 0.5f + 0.25f);
        this.reLoad(tag);
    }

    public CompoundTag getTag() {
        return (CompoundTag)this.f_19804_.m_135370_(DATA_TAG);
    }

    public void reLoad(CompoundTag tag) {
        this.f_19804_.m_135381_(DATA_TAG, (Object)new CompoundTag());
        this.f_19804_.m_135381_(DATA_TAG, (Object)tag);
    }

    @Override
    public Predicate<ItemStack> ammoPredicate() {
        return itemStack -> itemStack.m_204117_(BrassArmoryTags.Items.CANNON_AMMO);
    }

    public ItemStack getPowder() {
        return ArmoryUtil.loadStack((CompoundTag)this.f_19804_.m_135370_(DATA_TAG), "BAPowder", ItemStack.f_41583_);
    }

    @Override
    public Predicate<ItemStack> powderPredicate() {
        return itemStack -> itemStack.m_204117_(BrassArmoryTags.Items.FLINTLOCK_POWDER);
    }

    public void setFuse(int fuse) {
        this.f_19804_.m_135381_(DATA_FUSE, (Object)fuse);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE);
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public void setHurtDir(int hurtDir) {
        this.f_19804_.m_135381_(DATA_HURTDIR, (Object)hurtDir);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_HURTDIR);
    }

    public void setHurtTime(int hurtTime) {
        this.f_19804_.m_135381_(DATA_HURT, (Object)hurtTime);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_HURT);
    }

    public void setMoveTicks(int moveTicks) {
        this.f_19804_.m_135381_(DATA_MOVE_TICKS, (Object)moveTicks);
    }

    public int getMoveTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_MOVE_TICKS);
    }

    public void setSoundTicks(int soundTicks) {
        this.f_19804_.m_135381_(DATA_SOUND_TICKS, (Object)soundTicks);
    }

    public int getSoundTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_SOUND_TICKS);
    }

    @Override
    public double damage() {
        return 50.0;
    }

    @Override
    public float accuracy() {
        return 4.0f;
    }

    @Override
    public float speed() {
        return 4.0f;
    }

    @Override
    public float particleMultiplier() {
        return 1.75f;
    }

    @Override
    public double particleOffset() {
        return 1.4;
    }

    @Override
    public void onShoot(Level level, LivingEntity owner, Entity shooter, ItemStack ammoStack, @Nullable Projectile projectile) {
        if (projectile != null) {
            Vec3 vec3 = shooter.m_146892_().m_82549_(shooter.m_20252_(ArmoryUtil.frameTime(level)).m_82490_(this.particleOffset()));
            BlockHitResult blockHitResult = level.m_45547_(new ClipContext(shooter.m_146892_(), vec3, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, shooter));
            if (blockHitResult.m_6662_().equals((Object)HitResult.Type.MISS)) {
                projectile.m_146884_(vec3);
            }
        }
    }

    @NotNull
    public AABB m_6921_() {
        return super.m_6921_().m_82400_(1.2);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_8119_() {
        CompoundTag compoundTag;
        int fuse;
        int moveTicks;
        Entity entity;
        if (!this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60783_((BlockGetter)this.f_19853_, this.m_142538_().m_7495_(), Direction.UP)) {
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                this.dropItems();
            }
            this.m_146870_();
            return;
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 2.0f);
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if ((entity = this.m_6688_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float yRot = living.m_146908_();
            this.m_146922_(yRot);
            if (yRot != this.f_19859_) {
                this.setMoveTicks(40);
                this.setSoundTicks(this.getSoundTicks() + 1);
            }
            this.f_19859_ = this.m_146908_();
            float xRot = Mth.m_14036_((float)living.m_146909_(), (float)-45.0f, (float)15.0f);
            this.m_146926_(xRot);
            if (xRot != this.f_19860_) {
                this.setMoveTicks(40);
                this.setSoundTicks(this.getSoundTicks() + 1);
            }
            this.f_19860_ = this.m_146909_();
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        if ((moveTicks = this.getMoveTicks()) > 0) {
            this.setMoveTicks(moveTicks - 1);
            if (moveTicks >= 35) {
                this.f_19853_.m_6269_(null, (Entity)this, (SoundEvent)BrassArmorySounds.CANNON_MOVE.get(), SoundSource.NEUTRAL, Float.MIN_VALUE, Float.MIN_VALUE);
            }
        }
        if ((fuse = ((Integer)this.m_20088_().m_135370_(DATA_FUSE)).intValue()) > 0 && (compoundTag = (CompoundTag)this.f_19804_.m_135370_(DATA_TAG)).m_128441_(uuid)) {
            Player player = this.f_19853_.m_46003_(compoundTag.m_128342_(uuid));
            if (player == null) {
                this.f_19804_.m_135381_(DATA_FUSE, (Object)0);
                return;
            }
            if (fuse >= 30) {
                if (fuse == 30) {
                    GunBehaviours.getPowderBehaviour(this.getPowder()).ifPresent(powderBehaviour -> {
                        ItemStack ammo = this.getAmmo();
                        GunBehaviours.getAmmoBehavior(ammo).ifPresent(ammoBehaviour -> {
                            if (ammoBehaviour.onShoot(this.f_19853_, (LivingEntity)player, this, ammo, (AbstractPowderBehaviour)powderBehaviour, this) && !this.f_19853_.f_46443_) {
                                this.reLoad((CompoundTag)Util.m_137469_((Object)((CompoundTag)this.f_19804_.m_135370_(DATA_TAG)), tag -> {
                                    ArmoryUtil.clearStack(tag, "BAAmmo");
                                    ArmoryUtil.clearStack(tag, "BAPowder");
                                }));
                                if (player instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    BrassArmoryAdvancements.FIRE_CANNON.trigger(serverPlayer);
                                }
                            }
                            this.m_5496_((SoundEvent)BrassArmorySounds.CANNON_SHOOT.get(), 1.5f, this.f_19853_.m_5822_().nextFloat() * 0.5f + 1.25f);
                        });
                        Entity patt11423$temp = this.m_6688_();
                        if (patt11423$temp instanceof Player) {
                            Player plyr = (Player)patt11423$temp;
                            EffectCapabilityHandler.setShakePower(plyr, 1.75);
                        }
                    });
                } else if (fuse >= 40) {
                    this.f_19804_.m_135381_(DATA_FUSE, (Object)0);
                    return;
                }
            } else {
                this.m_5496_((SoundEvent)BrassArmorySounds.CANNON_FUSE.get(), 0.03f, this.f_19853_.m_5822_().nextFloat() * 0.6f + 1.0f);
            }
            this.m_20088_().m_135381_(DATA_FUSE, (Object)(fuse + 1));
        }
        super.m_8119_();
        if (this.getSoundTicks() > 0) {
            this.setSoundTicks(this.getSoundTicks() - 1);
        }
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public void m_7332_(Entity entity) {
        super.m_7332_(entity);
    }

    public void m_6053_() {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return !this.m_146910_();
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.7f;
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            if ((Integer)this.f_19804_.m_135370_(DATA_FUSE) == 0 && !this.f_19853_.f_46443_) {
                this.openInventory((ServerPlayer)player);
            }
            return InteractionResult.SUCCESS;
        }
        if (ArmoryUtil.isFuseLighter(player.m_21120_(hand))) {
            if ((Integer)this.f_19804_.m_135370_(DATA_FUSE) == 0) {
                if (!this.f_19853_.f_46443_) {
                    this.reLoad((CompoundTag)Util.m_137469_((Object)((CompoundTag)this.f_19804_.m_135370_(DATA_TAG)), tag -> tag.m_128362_(uuid, player.m_142081_())));
                    this.m_20088_().m_135381_(DATA_FUSE, (Object)1);
                    player.m_21120_(hand).m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(InteractionHand.MAIN_HAND));
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        player.m_146922_(this.m_146908_());
        player.m_146926_(this.m_146909_());
        player.m_20329_((Entity)this);
        return InteractionResult.SUCCESS;
    }

    public void openInventory(ServerPlayer player) {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(DATA_TAG);
        ArmoryUtil.addStack(tag, ((CannonItem)((Object)BrassArmoryItems.CANNON.get())).m_7968_(), "BAGunIcon");
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider(GunContainer.getServerContainer(this, tag), TextComponent.f_131282_));
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource source, float damage) {
        block12: {
            if (this.m_6673_(source)) {
                return false;
            }
            if (this.f_19853_.f_46443_ || this.m_146910_()) break block12;
            var4_3 = source.m_7640_();
            if (var4_3 instanceof Player && ArmoryUtil.isFuseLighter((p = (Player)var4_3).m_21205_()) && this.getFuse() == 0) {
                this.reLoad((CompoundTag)Util.m_137469_((Object)((CompoundTag)this.f_19804_.m_135370_(CannonEntity.DATA_TAG)), (Consumer<CompoundTag>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$hurt$7(net.minecraft.world.entity.player.Player net.minecraft.nbt.CompoundTag ), (Lnet/minecraft/nbt/CompoundTag;)V)((Player)p)));
                this.m_20088_().m_135381_(CannonEntity.DATA_FUSE, (Object)1);
                return true;
            }
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.m_5834_();
            culprit = source.m_7640_();
            this.m_146852_(GameEvent.f_157808_, culprit);
            damage = damage * 10.0f * (culprit instanceof LivingEntity != false ? 3.0f : 1.0f);
            damage *= source.m_19372_() != false ? 0.25f : 1.0f;
            if (!(culprit instanceof Player)) ** GOTO lbl-1000
            player = (Player)culprit;
            if (player.m_150110_().f_35937_ && !source.m_19372_() && !player.m_36341_()) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = flag = false;
            }
            if (flag || this.getDamage() + damage > this.getMaxHealth()) {
                if (!flag && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.dropItems();
                }
                this.m_146870_();
            } else if (culprit instanceof Player && (player = (Player)culprit).m_36341_()) {
                relativePos = this.m_142538_().m_142300_(player.m_6350_());
                if (CannonEntity.canSurvive(this.f_19853_, relativePos.m_7495_())) {
                    this.m_146884_(Vec3.m_82539_((Vec3i)relativePos));
                    this.f_19853_.m_7471_(relativePos, false);
                    if (this.getDamage() < this.getMaxHealth() * 0.5f) {
                        this.setDamage(this.getMaxHealth() * 0.5f);
                    }
                } else {
                    this.setDamage(this.getDamage() + damage);
                }
            } else {
                this.setDamage(this.getDamage() + damage);
            }
            return true;
        }
        return true;
    }

    public static boolean canSurvive(Level level, BlockPos blockPos) {
        BlockState blockstate = level.m_8055_(blockPos);
        if (!blockstate.m_60783_((BlockGetter)level, blockPos, Direction.UP)) {
            return false;
        }
        BlockPos blockpos1 = blockPos.m_7494_();
        BlockState blockstate1 = level.m_8055_(blockpos1);
        if (!blockstate1.m_60767_().m_76336_()) {
            return false;
        }
        return level.m_5450_(null, Shapes.m_83144_().m_83216_((double)blockpos1.m_123341_(), (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_()));
    }

    public boolean m_6673_(DamageSource damageSource) {
        return damageSource.m_19384_() || super.m_6673_(damageSource);
    }

    protected float getMaxHealth() {
        return 200.0f;
    }

    protected void dropItems() {
        this.m_19998_((ItemLike)this.getDropItem());
        if (!this.getAmmo().m_41619_()) {
            this.m_19983_(this.getAmmo());
        }
        if (!this.getPowder().m_41619_()) {
            this.m_19983_(this.getPowder());
        }
    }

    @NotNull
    public Item getDropItem() {
        return (Item)BrassArmoryItems.CANNON.get();
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("DataTag", 10)) {
            this.m_20088_().m_135381_(DATA_TAG, (Object)tag.m_128469_("DataTag"));
        }
        this.m_20088_().m_135381_(DATA_FUSE, (Object)tag.m_128451_("DataFuse"));
    }

    protected void m_7380_(CompoundTag tag) {
        if (!((CompoundTag)this.m_20088_().m_135370_(DATA_TAG)).m_128456_()) {
            tag.m_128365_("DataTag", (Tag)this.m_20088_().m_135370_(DATA_TAG));
        }
        tag.m_128405_("DataFuse", ((Integer)this.f_19804_.m_135370_(DATA_FUSE)).intValue());
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    protected Component m_5677_() {
        return this.getDropItem().m_41466_();
    }

    private static /* synthetic */ void lambda$hurt$7(Player p, CompoundTag tag) {
        tag.m_128362_(uuid, p.m_142081_());
    }
}

