/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.item.BoomerangItem;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BoomerangEntity
extends AbstractThrownWeaponEntity {
    protected static final EntityDataAccessor<Float> DATA_PLAYER_X = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> DATA_PLAYER_Y = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> DATA_PLAYER_Z = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private Vec3 deltaFirstMovement;
    public int spin = 0;

    public BoomerangEntity(EntityType<BoomerangEntity> entityType, Level level) {
        super(entityType, level);
    }

    public BoomerangEntity(Level level, LivingEntity livingEntity, ItemStack boomerangStack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.BOOMERANG.get()), livingEntity, level, boomerangStack);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)boomerangStack) > 0) {
            this.m_20254_(100);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PLAYER_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_PLAYER_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_PLAYER_Z, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void setPower(float power) {
        this.m_20242_(power > 0.25f);
        super.setPower(power);
    }

    @Override
    protected void loyaltyTick() {
        BlockPos pos = this.m_142538_();
        if (this.f_19853_.m_8055_(pos).m_60734_() == Blocks.f_50033_) {
            this.f_19853_.m_46953_(pos, true, this.m_37282_());
        }
        if (!this.m_20068_()) {
            return;
        }
        double loyaltyLevel = ((Integer)this.f_19804_.m_135370_(DATA_LOYALTY_LEVEL)).intValue();
        if (!this.f_36703_ || loyaltyLevel > 0.0) {
            if (this.deltaFirstMovement == null) {
                this.deltaFirstMovement = this.m_20184_();
            }
            Vec3 newMovement = this.deltaFirstMovement.m_82490_(Math.max(1.0 - (double)this.f_19797_ / 30.0, -1.0));
            if (this.f_36704_ > 4) {
                this.m_36790_(true);
            }
            if (loyaltyLevel > 0.0 && this.f_19797_ >= (this.f_19853_.f_46443_ ? 31 : 30)) {
                Vec3 deltaDifference;
                Entity entity = this.m_37282_();
                if (!(entity == null || !entity.m_6084_() || entity instanceof ServerPlayer && entity.m_5833_())) {
                    deltaDifference = entity.m_146892_().m_82546_(this.m_20182_());
                    this.f_19804_.m_135381_(DATA_PLAYER_X, (Object)Float.valueOf((float)deltaDifference.f_82479_));
                    this.f_19804_.m_135381_(DATA_PLAYER_Y, (Object)Float.valueOf((float)deltaDifference.f_82480_));
                    this.f_19804_.m_135381_(DATA_PLAYER_Z, (Object)Float.valueOf((float)deltaDifference.f_82481_));
                }
                deltaDifference = new Vec3((double)((Float)this.f_19804_.m_135370_(DATA_PLAYER_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(DATA_PLAYER_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(DATA_PLAYER_Z)).floatValue());
                double dif = newMovement.m_82553_() / deltaDifference.m_82553_();
                newMovement = deltaDifference.m_82490_(dif * (loyaltyLevel * 2.0));
            } else if (this.f_19797_ >= 70) {
                this.deltaFirstMovement = this.deltaFirstMovement.m_82520_(0.0, 0.025, 0.0);
            }
            this.m_20256_(newMovement);
            ++this.spin;
        } else {
            this.m_20242_(false);
        }
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity hitResultEntity = entityHitResult.m_82443_();
        LivingEntity owner = (LivingEntity)this.m_37282_();
        if (!this.f_19853_.m_5776_() && hitResultEntity == owner) {
            ItemStack boomerangStack = this.m_7846_();
            float crit = !this.m_20068_() || !this.dealtDamage || this.m_36797_() ? 0.0f : BoomerangItem.getCrit(boomerangStack) + 20.0f;
            BoomerangItem.setCrit(boomerangStack, crit, this.f_19853_.m_46467_());
            this.setItem(boomerangStack);
            boolean flag = true;
            if (owner.m_21205_().m_41619_() && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                owner.m_21008_(InteractionHand.MAIN_HAND, boomerangStack);
            } else if (owner.m_21206_().m_41619_() && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                owner.m_21008_(InteractionHand.OFF_HAND, boomerangStack);
            } else {
                Player player;
                boolean bl = flag = owner instanceof Player && this.m_142470_(player = (Player)owner);
            }
            if (flag) {
                owner.m_7938_((Entity)this, 1);
                this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                this.m_146870_();
            }
            return;
        }
        super.m_5790_(entityHitResult);
    }

    @Override
    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_37282_() == null) {
            boolean flag;
            boolean bl = flag = this.f_19797_ > 40 && (Integer)this.f_19804_.m_135370_(DATA_LOYALTY_LEVEL) > 0;
            if (!this.f_19853_.f_46443_ && (this.f_36703_ && this.f_36706_ <= 0 || flag)) {
                if (flag) {
                    List entitiesInRange = this.f_19853_.m_6443_(BoomerangEntity.class, player.m_142469_().m_82400_(0.2), Entity2 -> true);
                    if (!entitiesInRange.contains((Object)this)) {
                        return;
                    }
                    this.m_5790_(new EntityHitResult((Entity)player));
                } else if (this.m_142470_(player)) {
                    player.m_7938_((Entity)this, 1);
                    this.m_146870_();
                }
            }
        }
    }

    @Override
    protected String onHitDamageSource() {
        return "boomerang";
    }

    @Override
    protected SoundEvent onHitSoundEvent() {
        return (SoundEvent)BrassArmorySounds.BOOMERANG_HIT.get();
    }

    @Override
    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)BrassArmorySounds.BOOMERANG_HIT_GROUND.get();
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.WOODEN_BOOMERANG.get();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128347_("BAX", this.deltaFirstMovement.f_82479_);
        compoundTag.m_128347_("BAY", this.deltaFirstMovement.f_82480_);
        compoundTag.m_128347_("BAZ", this.deltaFirstMovement.f_82481_);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        double x = compoundTag.m_128459_("BAX");
        double y = compoundTag.m_128459_("BAY");
        double z = compoundTag.m_128459_("BAZ");
        this.deltaFirstMovement = new Vec3(x, y, z);
    }
}

