/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.item.FireRodItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class FireRodEntity
extends AbstractThrownWeaponEntity {
    public FireRodEntity(EntityType<FireRodEntity> entityType, Level level) {
        super(entityType, level);
    }

    public FireRodEntity(Level level, LivingEntity livingEntity, ItemStack spearStack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.FIRE_ROD.get()), livingEntity, level, spearStack);
        this.m_7311_(Integer.MAX_VALUE);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_20291_(0) && (this.f_36703_ || this.f_19853_.m_5822_().nextInt(2) == 1)) {
            SimpleParticleType simpleParticleType;
            Vec3 smokeVec = this.m_20182_();
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, smokeVec.f_82479_, smokeVec.f_82480_, smokeVec.f_82481_, 0.0, 0.0, 0.0);
            Item item = this.m_7846_().m_41720_();
            if (item instanceof FireRodItem) {
                FireRodItem fireRod = (FireRodItem)item;
                simpleParticleType = fireRod.flameParticle;
            } else {
                simpleParticleType = ParticleTypes.f_123744_;
            }
            this.f_19853_.m_7106_((ParticleOptions)simpleParticleType, smokeVec.f_82479_, smokeVec.f_82480_, smokeVec.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        ArmoryUtil.blockHitSetOnFire(blockHitResult, this.f_19853_, this.m_37282_());
    }

    public boolean m_6060_() {
        return !this.f_19853_.f_46443_ && super.m_6060_();
    }

    public boolean hasBeenExtinguished() {
        return !this.m_20291_(0);
    }

    @Override
    protected String onHitDamageSource() {
        return "fire_rod";
    }

    @Override
    protected SoundEvent onHitSoundEvent() {
        return (SoundEvent)BrassArmorySounds.FIRE_ROD_HIT.get();
    }

    @Override
    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)BrassArmorySounds.FIRE_ROD_HIT_GROUND.get();
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.FIRE_ROD.get();
    }
}

