/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractRollableItemProjectileEntity;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.item.FlailItem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class FlailHeadEntity
extends AbstractThrownWeaponEntity {
    protected static final EntityDataAccessor<Integer> DATA_OWNER = SynchedEntityData.m_135353_(FlailHeadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int hitPerTick;
    protected long hitTick;

    public FlailHeadEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public FlailHeadEntity(LivingEntity living, Level level, ItemStack weaponStack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.FLAIL_HEAD.get()), living, level, weaponStack);
        Item item;
        this.hitTick = Long.MAX_VALUE;
        double damage = living.m_21133_(Attributes.f_22281_);
        ItemStack mainHandItem = living.m_21205_();
        if (mainHandItem != weaponStack && !mainHandItem.m_41619_()) {
            for (AttributeModifier attributeModifier : mainHandItem.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
                damage -= attributeModifier.m_22218_();
            }
        }
        if ((item = weaponStack.m_41720_()) instanceof FlailItem) {
            FlailItem flailItem = (FlailItem)item;
            damage += (double)flailItem.getAttackDamage();
        }
        this.f_19804_.m_135381_(DATA_DAMAGE_VALUE, (Object)Float.valueOf((float)damage));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNER, (Object)Integer.MAX_VALUE);
    }

    @Override
    public void m_8119_() {
        LivingEntity living;
        Entity entity;
        if (this.f_19797_ > 200) {
            this.m_6074_();
            return;
        }
        this.hitPerTick = 0;
        if ((Integer)this.f_19804_.m_135370_(DATA_OWNER) == Integer.MAX_VALUE && this.m_37282_() != null) {
            this.f_19804_.m_135381_(DATA_OWNER, (Object)this.m_37282_().m_142049_());
        }
        super.m_8119_();
        if (this.m_20096_()) {
            this.onGroundTick();
        }
        if (!this.f_19853_.f_46443_ && (this.hitTick != Long.MAX_VALUE && this.f_19853_.m_46467_() - this.hitTick > 5L || (entity = this.m_37282_()) instanceof LivingEntity && (double)(living = (LivingEntity)entity).m_20270_((Entity)this) > 8.0)) {
            this.f_19804_.m_135381_(DATA_LOYALTY_LEVEL, (Object)21);
            this.m_36790_(true);
        }
    }

    protected void onGroundTick() {
        Vec3 vec = this.m_20184_();
        boolean flag = this.m_20229_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        this.m_20256_(vec.m_82542_(0.9, flag ? 1.0 : 0.0, 0.9));
        this.m_6853_(!flag);
    }

    protected void m_6532_(HitResult hitResult) {
        switch (hitResult.m_6662_()) {
            case ENTITY: {
                this.m_5790_((EntityHitResult)hitResult);
                break;
            }
            case BLOCK: {
                this.m_8060_((BlockHitResult)hitResult);
                break;
            }
            default: {
                return;
            }
        }
        if (this.hitTick == Long.MAX_VALUE) {
            this.hitTick = this.f_19853_.m_46467_();
        }
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity;
        if (!this.f_19861_ && (entity = entityHitResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.m_37282_() != null && this.m_37282_().m_142081_() != living.m_142081_()) {
                super.m_5790_(entityHitResult);
                living.m_147240_(this.m_20184_().m_82553_() * 0.25, this.m_20185_() - living.m_20185_(), this.m_20189_() - living.m_20189_());
            }
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        if (this.f_19797_ > 200) {
            this.m_146870_();
            return;
        }
        if (this.hitPerTick == 0) {
            this.onHitEffects();
        }
        if (++this.hitPerTick > 8) {
            this.m_146870_();
            return;
        }
        BlockPos pos = blockHitResult.m_82425_();
        BlockState blockState = this.f_19853_.m_8055_(pos);
        if (blockState.m_60734_() instanceof IronBarsBlock && blockState.m_60767_().equals(Material.f_76275_)) {
            this.f_19853_.m_46953_(pos, true, this.m_37282_());
            this.m_20256_(this.m_20184_().m_82490_(0.85));
            return;
        }
        BlockState blockstate = this.f_19853_.m_8055_(pos);
        blockstate.m_60669_(this.f_19853_, blockstate, blockHitResult, (Projectile)this);
        Direction.Axis axis = blockHitResult.m_82434_().m_122434_();
        Vec3 movement = AbstractRollableItemProjectileEntity.bounce(this.m_20184_(), axis, 0.2);
        this.m_20256_(movement);
        HitResult newHitResult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (newHitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.m_6532_(newHitResult);
        } else if (movement.f_82480_ < 0.05 && blockHitResult.m_82434_() == Direction.UP) {
            this.m_6853_(true);
            this.m_20334_(movement.f_82479_, 0.0, movement.f_82481_);
        }
    }

    protected void onHitEffects() {
        float volume = (float)this.m_20184_().m_82553_() * 0.5f;
        this.m_5496_(this.onHitSoundEvent(), volume, ((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f) / 0.8f);
    }

    @Nullable
    public Entity m_37282_() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNER) != Integer.MAX_VALUE ? this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(DATA_OWNER)).intValue()) : super.m_37282_();
    }

    @Override
    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    @Override
    @NotNull
    public Component m_7755_() {
        return this.m_5677_();
    }

    @Override
    protected boolean m_142470_(Player player) {
        if (this.m_36797_() && this.m_150171_((Entity)player)) {
            player.m_36335_().m_41524_(this.m_7846_().m_41720_(), 5);
            return true;
        }
        return false;
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128356_("BAHitTick", this.hitTick);
        super.m_7380_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.hitTick = compoundTag.m_128454_("BAHitTick");
    }

    @Override
    protected String onHitDamageSource() {
        return "flail";
    }

    @Override
    protected SoundEvent onHitSoundEvent() {
        return (SoundEvent)BrassArmorySounds.FLAIL_HIT.get();
    }

    @Override
    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)BrassArmorySounds.FLAIL_HIT.get();
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.WOODEN_SPIKY_BALL.get();
    }
}

