/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.arrow;

import com.milamber_brass.brass_armory.client.render.SpecialArrowRenderer;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractSpecialArrowEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.SpecialArrowItem;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class FrostArrowEntity
extends AbstractSpecialArrowEntity {
    public FrostArrowEntity(EntityType<? extends FrostArrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public FrostArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.FROST_ARROW.get()), level, shooter);
        this.m_36781_(3.0);
    }

    public FrostArrowEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.FROST_ARROW.get()), level, x, y, z);
        this.m_36781_(3.0);
    }

    @Override
    public void m_8119_() {
        BlockState state;
        Vec3 nextPos;
        Vec3 thisPos;
        BlockHitResult blockHitResult;
        if (!this.dealtDamage && (blockHitResult = this.f_19853_.m_45547_(new ClipContext(thisPos = this.m_20182_(), nextPos = thisPos.m_82549_(this.m_20184_().m_82490_(1.1)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this))).m_6662_().equals((Object)HitResult.Type.BLOCK) && (state = this.f_19853_.m_8055_(blockHitResult.m_82425_())).m_60713_(Blocks.f_49990_) && (!this.m_5842_() && this.f_19797_ > 2 || !this.f_19853_.m_8055_(this.m_142538_()).m_60713_(Blocks.f_49990_))) {
            FrostArrowEntity.freezeAOE(this.f_19853_, blockHitResult.m_82425_(), (Entity)this);
            this.dealtDamage = true;
        }
        super.m_8119_();
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 70, 3));
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.dealtDamage) {
            FrostArrowEntity.freezeAOE(this.f_19853_, result.m_82425_(), (Entity)this);
        }
    }

    public static void freezeAOE(Level level, BlockPos pos, @Nullable Entity entity) {
        BlockState blockstate = Blocks.f_50126_.m_49966_();
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_142022_(-3.0, 0.0, -3.0), (BlockPos)pos.m_142022_(3.0, 0.0, 3.0))) {
            FluidState flu;
            if (!blockpos.m_123314_((Vec3i)pos, 2.5) || !(flu = level.m_6425_(blockpos)).m_205070_(FluidTags.f_13131_) || !flu.m_76170_() || !level.m_8055_(blockpos).m_60767_().m_76336_() || !blockstate.m_60710_((LevelReader)level, blockpos) || ForgeEventFactory.onBlockPlace((Entity)entity, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)blockpos), (Direction)Direction.UP)) continue;
            level.m_46597_(blockpos, blockstate);
            level.m_186460_(blockpos, Blocks.f_50449_, Mth.m_14072_((Random)level.f_46441_, (int)60, (int)120));
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ((SpecialArrowItem)((Object)BrassArmoryItems.FROST_ARROW.get())).m_7968_();
    }

    @Override
    protected void spawnArrowParticles(int particleCount) {
        for (int j = 0; j < particleCount; ++j) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123804_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 40.0, 75.0, 40.0);
        }
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return SpecialArrowRenderer.FROST_ARROW_TEXTURE;
    }
}

