/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.arrow;

import com.milamber_brass.brass_armory.client.render.SpecialArrowRenderer;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractRollableItemProjectileEntity;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractSpecialArrowEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.SpecialArrowItem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class SlimeArrowEntity
extends AbstractSpecialArrowEntity {
    public SlimeArrowEntity(EntityType<? extends SlimeArrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SlimeArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.SLIME_ARROW.get()), level, shooter);
        this.m_36781_(0.5);
    }

    public SlimeArrowEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.SLIME_ARROW.get()), level, x, y, z);
        this.m_36781_(0.5);
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        if (!this.dealtDamage) {
            living.m_147240_(this.m_20184_().m_82553_() * 0.75, this.m_20185_() - living.m_20185_(), this.m_20189_() - living.m_20189_());
        }
    }

    protected void m_8060_(BlockHitResult result) {
        if (!this.dealtDamage) {
            this.m_20256_(AbstractRollableItemProjectileEntity.bounce(this.m_20184_(), result.m_82434_().m_122434_(), 0.75));
            return;
        }
        if (this.f_19796_.nextInt(10) == 0) {
            this.spawnSmallSlime();
        }
        super.m_8060_(result);
    }

    private void spawnSmallSlime() {
        if (this.m_6084_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46134_)) {
            Slime slimeEntity = (Slime)EntityType.f_20526_.m_20615_(this.f_19853_);
            if (slimeEntity == null) {
                return;
            }
            slimeEntity.m_20049_("no_loot");
            slimeEntity.m_6210_();
            slimeEntity.m_21153_(1.0f);
            slimeEntity.m_7678_((double)((float)this.m_142538_().m_123341_() + 0.5f), (double)((float)this.m_142538_().m_123342_() + 0.05f), (double)((float)this.m_142538_().m_123343_() + 0.5f), this.m_146908_(), this.m_146909_());
            this.f_19853_.m_7967_((Entity)slimeEntity);
            this.m_146870_();
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ((SpecialArrowItem)((Object)BrassArmoryItems.SLIME_ARROW.get())).m_7968_();
    }

    @Override
    protected void spawnArrowParticles(int particleCount) {
        if (this.f_19796_.nextInt(2) >= particleCount) {
            return;
        }
        for (int j = 0; j < particleCount; ++j) {
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50374_.m_49966_()), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 40.0, 75.0, 40.0);
        }
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return SpecialArrowRenderer.SLIME_ARROW_TEXTURE;
    }
}

