/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.event;

import com.milamber_brass.brass_armory.capabilities.IEffectCapability;
import com.milamber_brass.brass_armory.capabilities.IQuiverCapability;
import com.milamber_brass.brass_armory.data.BrassArmoryTags;
import com.milamber_brass.brass_armory.effect.BleedEffect;
import com.milamber_brass.brass_armory.entity.CannonEntity;
import com.milamber_brass.brass_armory.entity.projectile.bomb.BombEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryCapabilities;
import com.milamber_brass.brass_armory.init.BrassArmoryEffects;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.BombItem;
import com.milamber_brass.brass_armory.item.LongBowItem;
import com.milamber_brass.brass_armory.item.QuiverItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber(modid="brass_armory")
public class UniversalEventSubscriber {
    @SubscribeEvent
    public static void onPlayerContainerEventOpen(PlayerContainerEvent.Open event) {
        Player player = event.getPlayer();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            Item item = stack.m_41720_();
            if (!(item instanceof BombItem)) continue;
            BombItem bombItem = (BombItem)item;
            if (!BombItem.getFuseLit(stack)) continue;
            BombEntity bomb = (BombEntity)((Object)bombItem.newBombFunction.m_125475_((Object)player.f_19853_, (Object)player, (Object)player.m_5737_()));
            bomb.setFuse(BombItem.getFuseLength(stack));
            bomb.m_37446_(stack);
            BombItem.setFuseLength(stack, 60);
            BombItem.setFuseLit(stack, false);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            player.f_19853_.m_7967_((Entity)bomb);
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        event.getRareTrades().add(new BasicItemListing(8, ((BombItem)((Object)BrassArmoryItems.BOMB.get())).m_7968_(), 8, 4, 4.0f));
        event.getRareTrades().add(new BasicItemListing(10, ((LongBowItem)((Object)BrassArmoryItems.LONGBOW.get())).m_7968_(), 3, 6, 1.0f));
        event.getRareTrades().add(new BasicItemListing(Items.f_42679_.m_7968_(), ((SwordItem)BrassArmoryItems.KATANA.get()).m_7968_(), 1, 32, 1.0f));
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        ItemSupplier itemSupplier;
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof ItemSupplier && (itemSupplier = (ItemSupplier)entity).m_7846_().m_204117_(BrassArmoryTags.Items.BLEEDING_EDGE)) {
            BleedEffect.bleedHarder(event.getEntityLiving(), 50, 0);
        }
    }

    @SubscribeEvent
    public static void onPotionApplicableEvent(PotionEvent.PotionApplicableEvent event) {
        LivingEntity living;
        Entity entity;
        if (event.getPotionEffect().m_19544_().equals(BrassArmoryEffects.BLEEDING.get()) && (entity = event.getEntity()) instanceof LivingEntity && ((living = (LivingEntity)entity).m_6336_() == MobType.f_21641_ || living.m_6126_() || living instanceof AbstractGolem || living instanceof Slime)) {
            event.setResult(Event.Result.DENY);
            return;
        }
        event.setResult(Event.Result.DEFAULT);
    }

    @SubscribeEvent
    public static void onPotionAddedEvent(PotionEvent.PotionAddedEvent event) {
        MobEffect effect;
        LivingEntity living = event.getEntityLiving();
        if (!living.f_19853_.f_46443_ && ((effect = event.getPotionEffect().m_19544_()).equals(BrassArmoryEffects.BLEEDING.get()) || effect.equals(BrassArmoryEffects.CONFUSION.get()))) {
            ((ServerLevel)living.f_19853_).m_7726_().f_8325_.m_140201_((Entity)living, (Packet)new ClientboundUpdateMobEffectPacket(living.m_142049_(), event.getPotionEffect()));
        }
    }

    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        LivingEntity living = event.getEntityLiving();
        Set tags = living.m_19880_();
        if (!tags.isEmpty() && tags.contains("no_loot")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.m_5776_() && !player.m_21224_()) {
                player.getCapability(BrassArmoryCapabilities.QUIVER_CAPABILITY).ifPresent(IQuiverCapability::tick);
                player.getCapability(BrassArmoryCapabilities.EFFECT_CAPABILITY).ifPresent(IEffectCapability::tick);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingGetProjectileEvent(LivingGetProjectileEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (ItemStack quiverStack : player.m_150109_().f_35974_) {
                Optional<ItemStack> optionalInQuiverStack;
                if (!(quiverStack.m_41720_() instanceof QuiverItem) || !(optionalInQuiverStack = QuiverItem.getContents(quiverStack).findFirst()).isPresent()) continue;
                if (!player.f_19853_.m_5776_()) {
                    player.getCapability(BrassArmoryCapabilities.QUIVER_CAPABILITY).ifPresent(capability -> {
                        capability.setAmmoStack((ItemStack)optionalInQuiverStack.get());
                        capability.setQuiverStack(quiverStack);
                        event.setProjectileItemStack(capability.getAmmoStack());
                    });
                } else {
                    event.setProjectileItemStack(optionalInQuiverStack.get());
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(PlayerInteractEvent.RightClickItem event) {
        CannonEntity cannon;
        Player player;
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_20159_() && (livingEntity = player.m_20202_()) instanceof CannonEntity && (cannon = (CannonEntity)livingEntity).getFuse() == 0 && ArmoryUtil.isFuseLighter(event.getItemStack()) && event.getHand().equals((Object)InteractionHand.MAIN_HAND)) {
            event.setCanceled(true);
            event.setCancellationResult(cannon.m_6096_(player, event.getHand()));
        }
    }
}

