/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.init;

import com.milamber_brass.brass_armory.capabilities.EffectCapabilityHandler;
import com.milamber_brass.brass_armory.capabilities.IEffectCapability;
import com.milamber_brass.brass_armory.capabilities.IPowderCapability;
import com.milamber_brass.brass_armory.capabilities.IQuiverCapability;
import com.milamber_brass.brass_armory.capabilities.PowderCapabilityHandler;
import com.milamber_brass.brass_armory.capabilities.QuiverCapabilityHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

@ParametersAreNonnullByDefault
public class BrassArmoryCapabilities {
    public static final Capability<IQuiverCapability> QUIVER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IQuiverCapability>(){});
    public static final Capability<IPowderCapability> POWDER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPowderCapability>(){});
    public static final Capability<IEffectCapability> EFFECT_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IEffectCapability>(){});

    public static void capabilitySetup(RegisterCapabilitiesEvent event) {
        event.register(IQuiverCapability.class);
        event.register(IPowderCapability.class);
        event.register(IEffectCapability.class);
    }

    public static void addCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            final Player player = (Player)object;
            event.addCapability(IQuiverCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                final LazyOptional<IQuiverCapability> inst = LazyOptional.of(() -> {
                    QuiverCapabilityHandler quiverCapabilityHandler = new QuiverCapabilityHandler();
                    quiverCapabilityHandler.setEntity(player);
                    return quiverCapabilityHandler;
                });

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                    return QUIVER_CAPABILITY.orEmpty(capability, this.inst.cast());
                }

                public CompoundTag serializeNBT() {
                    return (CompoundTag)((IQuiverCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundTag compoundTag) {
                    ((IQuiverCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)compoundTag);
                }
            });
            event.addCapability(IEffectCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                final LazyOptional<IEffectCapability> inst = LazyOptional.of(() -> {
                    EffectCapabilityHandler shakeCapabilityHandler = new EffectCapabilityHandler();
                    shakeCapabilityHandler.setEntity(player);
                    return shakeCapabilityHandler;
                });

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                    return EFFECT_CAPABILITY.orEmpty(capability, this.inst.cast());
                }

                public CompoundTag serializeNBT() {
                    return (CompoundTag)((IEffectCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundTag compoundTag) {
                    ((IEffectCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)compoundTag);
                }
            });
        } else {
            object = event.getObject();
            if (object instanceof Projectile) {
                final Projectile projectile = (Projectile)object;
                event.addCapability(IPowderCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                    final LazyOptional<IPowderCapability> inst = LazyOptional.of(() -> {
                        PowderCapabilityHandler powderCapabilityHandler = new PowderCapabilityHandler();
                        powderCapabilityHandler.setEntity(projectile);
                        return powderCapabilityHandler;
                    });

                    @Nonnull
                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                        return POWDER_CAPABILITY.orEmpty(capability, this.inst.cast());
                    }

                    public CompoundTag serializeNBT() {
                        return (CompoundTag)((IPowderCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                    }

                    public void deserializeNBT(CompoundTag compoundTag) {
                        ((IPowderCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)compoundTag);
                    }
                });
            }
        }
    }
}

