/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.inventory;

import com.milamber_brass.brass_armory.BrassArmory;
import com.milamber_brass.brass_armory.behaviour.iGun;
import com.milamber_brass.brass_armory.init.BrassArmoryMenus;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class GunContainer<T extends iGun>
extends AbstractContainerMenu {
    public static final ResourceLocation EMPTY_POWDER_SLOT = BrassArmory.locate("gui/empty_powder_slot");
    public static final ResourceLocation EMPTY_AMMO_SLOT = BrassArmory.locate("gui/empty_ammo_slot");
    public static final String gunIcon = "BAGunIcon";
    public static final String gunAmmo = "BAAmmo";
    public static final String gunPowder = "BAPowder";
    public final iGun gun;
    public final CompoundTag tag;
    private final Slot ammoSlot;
    private final Slot powderSlot;
    public final Slot iconSlot;

    public GunContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, (IItemHandler)new ItemStackHandler(3), null, new CompoundTag());
    }

    public GunContainer(int id, Inventory playerInventory, IItemHandler slot, @Nullable T gun, CompoundTag tag) {
        super((MenuType)BrassArmoryMenus.GUN_MENU.get(), id);
        this.gun = gun;
        this.tag = tag;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new DefaultSlot((Container)playerInventory, 9 + row * 9 + column, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.m_38897_(new DefaultSlot((Container)playerInventory, column, 8 + column * 18, 142));
        }
        this.m_38897_(new DefaultSlot((Container)playerInventory, 40, 8, 50){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        this.ammoSlot = this.m_38897_((Slot)new GunSlot(slot, 0, 61, 24, gun != null ? gun.ammoPredicate() : inputStack -> true, 1){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_AMMO_SLOT);
            }
        });
        this.ammoSlot.m_5852_(ArmoryUtil.loadStack(tag, gunAmmo, ItemStack.f_41583_));
        this.powderSlot = this.m_38897_((Slot)new GunSlot(slot, 1, 99, 24, gun != null ? gun.powderPredicate() : inputStack -> true, 1){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_POWDER_SLOT);
            }
        });
        this.powderSlot.m_5852_(ArmoryUtil.loadStack(tag, gunPowder, ItemStack.f_41583_));
        this.iconSlot = this.m_38897_((Slot)new GunSlot(slot, 2, 80, 24){

            public boolean m_150651_(Player player) {
                return false;
            }

            public boolean m_6659_() {
                return false;
            }
        });
        this.iconSlot.m_5852_(ArmoryUtil.loadStack(tag, gunIcon, ItemStack.f_41583_).m_41777_());
        if (gun != null) {
            gun.onOpen(playerInventory.f_35978_, tag);
        }
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack retStack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            ItemStack item = slot.m_7993_();
            retStack = item.m_41777_();
            if (index < 27 ? !this.m_38903_(item, 27, 36, false) : !this.m_38903_(item, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            if (item.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return retStack;
    }

    @Nonnull
    public static MenuConstructor getServerContainer(iGun gun, CompoundTag tag) {
        return (id, playerInv, player) -> new GunContainer<iGun>(id, playerInv, (IItemHandler)new ItemStackHandler(3), gun, tag);
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        ArmoryUtil.clearStack(this.tag, gunAmmo);
        ItemStack ammoStack = this.ammoSlot.m_7993_();
        if (!ammoStack.m_41619_()) {
            ArmoryUtil.addStack(this.tag, ammoStack, gunAmmo);
        }
        ArmoryUtil.clearStack(this.tag, gunPowder);
        ItemStack powderStack = this.powderSlot.m_7993_();
        if (!powderStack.m_41619_()) {
            ArmoryUtil.addStack(this.tag, powderStack, gunPowder);
        }
        if (this.gun != null) {
            this.gun.onLoad(player, this.tag);
        }
    }

    static class DefaultSlot
    extends Slot {
        public DefaultSlot(Container container, int index, int xPosition, int yPosition) {
            super(container, index, xPosition, yPosition);
        }

        public boolean m_8010_(Player player) {
            return !(this.m_7993_().m_41720_() instanceof iGun);
        }
    }

    static class GunSlot
    extends SlotItemHandler {
        private final Predicate<ItemStack> mayPlace;
        private final int maxStack;

        public GunSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, Predicate<ItemStack> mayPlace, int maxStack) {
            super(itemHandler, index, xPosition, yPosition);
            this.mayPlace = mayPlace;
            this.maxStack = maxStack;
        }

        public GunSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            this(itemHandler, index, xPosition, yPosition, itemStack -> true, 64);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return this.mayPlace.test(stack);
        }

        public int m_6641_() {
            return this.maxStack;
        }

        public int m_5866_(@NotNull ItemStack stack) {
            return this.m_6641_();
        }
    }
}

