/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.google.common.collect.ImmutableMultimap;
import com.milamber_brass.brass_armory.entity.projectile.FlailHeadEntity;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.item.SpikyBallItem;
import com.milamber_brass.brass_armory.item.abstracts.AbstractThrownWeaponItem;
import com.milamber_brass.brass_armory.item.interfaces.ICustomAnimationItem;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class FlailItem
extends AbstractThrownWeaponItem
implements ICustomAnimationItem {
    protected final SpikyBallItem head;
    protected final float attackDamage;

    public FlailItem(Tier tier, float attackDamageIn, SpikyBallItem head, Item.Properties properties) {
        super(tier, attackDamageIn, -2.6f, 10.0f, 1.0f, properties);
        this.head = head;
        this.attackDamage = attackDamageIn + tier.m_6631_();
    }

    public SpikyBallItem getHead() {
        return this.head;
    }

    @Override
    public float getAttackDamage() {
        return this.attackDamage;
    }

    @Override
    protected ImmutableMultimap.Builder<Attribute, AttributeModifier> setDefaultModifiers(float attackDamage, float attackSpeed) {
        return null;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return this.isExtended((LivingEntity)player, player.m_21120_(hand)) ? InteractionResultHolder.m_19100_((Object)player.m_21120_(hand)) : super.m_7203_(level, player, hand);
    }

    @Override
    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        stack.m_41622_(1, entityLiving, player1 -> player1.m_21190_(InteractionHand.MAIN_HAND));
        super.m_5551_(stack, level, entityLiving, timeLeft);
    }

    @Override
    @NotNull
    public SoundEvent throwSound() {
        return (SoundEvent)BrassArmorySounds.FLAIL_THROW.get();
    }

    public boolean isExtended(LivingEntity living, ItemStack stack) {
        List flails = living.f_19853_.m_6249_((Entity)living, living.m_142469_().m_82400_(20.0), entity -> entity instanceof FlailHeadEntity);
        for (Entity entity2 : flails) {
            FlailHeadEntity flailHead;
            if (!(entity2 instanceof FlailHeadEntity) || (flailHead = (FlailHeadEntity)entity2).m_37282_() != living || !flailHead.m_7846_().equals(stack, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean shrinkItem() {
        return false;
    }

    @Override
    @NotNull
    protected AbstractThrownWeaponEntity getEntity(Level level, LivingEntity living, ItemStack weaponStack) {
        return new FlailHeadEntity(living, level, weaponStack);
    }

    @Override
    public float getChargeDuration(ItemStack itemStack) {
        return this.chargeDuration;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && enchantment != Enchantments.f_44955_;
    }
}

