/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.milamber_brass.brass_armory.init.BrassArmoryCapabilities;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.util.ArmoryCooldownCache;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class WarpCrystalItem
extends Item {
    public static final int WARP_TICKS = 40;
    public final int maxDistance;

    public WarpCrystalItem(Item.Properties properties, int maxDistance) {
        super(properties);
        this.maxDistance = maxDistance;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int useDurationLeft) {
        if (living.f_19853_.f_46443_) {
            living.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, living.m_20208_(0.5), living.m_20187_() - 0.25, living.m_20262_(0.5), (living.f_19853_.f_46441_.nextDouble() - 0.5) * 2.0, -living.f_19853_.f_46441_.nextDouble(), (living.f_19853_.f_46441_.nextDouble() - 0.5) * 2.0);
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            player.getCapability(BrassArmoryCapabilities.EFFECT_CAPABILITY).ifPresent(iEffectCapability -> {
                int usedTicks = this.m_8105_(stack) - useDurationLeft;
                float slow = iEffectCapability.getSlow();
                if (living.f_19853_.f_46443_) {
                    Minecraft mc = Minecraft.m_91087_();
                    if (mc.m_91288_() == living) {
                        int beatTick = useDurationLeft % 34;
                        double x = living.m_20185_();
                        double y = living.m_20186_();
                        double z = living.m_20189_();
                        if (beatTick == 10) {
                            living.f_19853_.m_7785_(x, y, z, (SoundEvent)BrassArmorySounds.HEART_BEAT_1.get(), SoundSource.PLAYERS, 0.05f + slow, 0.23333333f * slow - slow, false);
                        } else if (beatTick == 15) {
                            living.f_19853_.m_7785_(x, y, z, (SoundEvent)BrassArmorySounds.HEART_BEAT_2.get(), SoundSource.PLAYERS, 0.05f + slow, 0.26666668f * slow - slow, false);
                        }
                        if (usedTicks >= 40 && useDurationLeft % 20 == 0 && living.f_19853_.f_46441_.nextInt(2) == 0) {
                            living.f_19853_.m_7785_(x, y, z, (SoundEvent)BrassArmorySounds.CRYSTAL_WHISPER.get(), SoundSource.PLAYERS, 0.2f, living.m_6100_() * 0.02f, false);
                        }
                    }
                } else {
                    iEffectCapability.setSlow(Mth.m_14036_((float)((float)usedTicks / 40.0f * 0.25f), (float)slow, (float)0.25f));
                }
            });
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int useDurationLeft) {
        int usedTicks = this.m_8105_(stack) - useDurationLeft;
        Vec3 farPoint = living.m_20154_().m_82490_((double)this.maxDistance).m_82549_(living.m_20182_());
        double farY = farPoint.f_82480_;
        if (usedTicks >= 38) {
            for (int i = this.maxDistance; i > 0; i -= Mth.m_14045_((int)(i / 25), (int)1, (int)3)) {
                farPoint = living.m_20154_().m_82490_((double)i).m_82549_(living.m_20182_());
                if (!(farPoint.f_82480_ < (double)level.m_151558_()) && !(farPoint.f_82480_ < Math.sqrt(farY - (double)level.m_151558_()) + (double)level.m_151558_()) || !(farPoint.f_82480_ > (double)level.m_141937_())) continue;
                for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)new BlockPos(farPoint).m_142022_(-1.0, 0.0, -1.0), (BlockPos)new BlockPos(farPoint).m_142022_(1.0, 0.0, 1.0))) {
                    if (level.m_8055_(blockpos).m_60767_().m_76334_() || level.m_8055_(blockpos.m_7494_()).m_60767_().m_76334_()) continue;
                    Vec3 vec = living.m_146892_().m_82549_(living.m_20154_());
                    for (int l2 = 0; l2 < 8; ++l2) {
                        level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec.f_82479_, vec.f_82480_, vec.f_82481_, level.f_46441_.nextGaussian() * 0.15, level.f_46441_.nextDouble() * 0.2, level.f_46441_.nextGaussian() * 0.15);
                    }
                    farPoint = Vec3.m_82539_((Vec3i)blockpos);
                    living.m_20324_(farPoint.f_82479_, farPoint.f_82480_, farPoint.f_82481_);
                    level.m_6269_(null, (Entity)living, (SoundEvent)BrassArmorySounds.CRYSTAL_WARP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (living instanceof Player) {
                        Player player = (Player)living;
                        if (!player.m_150110_().f_35937_ && player.m_21187_().nextInt(5) > 0) {
                            stack.m_41774_(1);
                        }
                        ArmoryUtil.addCooldownToList(player, ArmoryCooldownCache.BrassArmoryWarpCrystals, 1200);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    }
                    return;
                }
            }
        }
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }
}

