/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.jei;

import com.milamber_brass.brass_armory.BrassArmory;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.jei.TorchSubtypeInterpreter;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.plugins.vanilla.brewing.PotionSubtypeInterpreter;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@JeiPlugin
public class JeiModPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return BrassArmory.locate("jei");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)BrassArmoryItems.CARCASS_ROUND.get()), (IIngredientSubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)BrassArmoryItems.TORCH_ARROW.get()), (IIngredientSubtypeInterpreter)TorchSubtypeInterpreter.INSTANCE);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            registration.addRecipes(RecipeTypes.CRAFTING, JeiModPlugin.regCarcassRounds(level.m_7465_()));
            registration.addRecipes(RecipeTypes.CRAFTING, JeiModPlugin.regTorchArrows(level.m_7465_()));
        }
    }

    @NotNull
    public static List<CraftingRecipe> regCarcassRounds(RecipeManager recipeManager) {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (Recipe recipe : recipeManager.m_44051_()) {
            CraftingRecipe craftingRecipe;
            if (!(recipe instanceof CraftingRecipe) || !(craftingRecipe = (CraftingRecipe)recipe).m_8043_().m_150930_((Item)BrassArmoryItems.CARCASS_ROUND.get()) || craftingRecipe.m_7527_().isEmpty()) continue;
            NonNullList ingredients = craftingRecipe.m_7527_();
            ItemStack result = craftingRecipe.m_8043_();
            for (Potion potion : ForgeRegistries.POTIONS.getValues()) {
                NonNullList newIngredients = NonNullList.m_122779_();
                boolean flag = false;
                for (Ingredient ingredient : ingredients) {
                    if (ingredient.test(new ItemStack((ItemLike)Items.f_42739_))) {
                        newIngredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)potion)}));
                        flag = true;
                        continue;
                    }
                    newIngredients.add((Object)ingredient);
                }
                if (!flag) continue;
                if (craftingRecipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)craftingRecipe;
                    recipes.add((CraftingRecipe)new ShapedRecipe(BrassArmory.locate(potion.m_43492_("carcass_round.")), "brass_armory.jei.carcass_round", shapedRecipe.m_44220_(), shapedRecipe.m_44221_(), newIngredients, PotionUtils.m_43549_((ItemStack)result.m_41777_(), (Potion)potion)));
                    continue;
                }
                if (!(craftingRecipe instanceof ShapelessRecipe)) continue;
                recipes.add((CraftingRecipe)new ShapelessRecipe(BrassArmory.locate(potion.m_43492_("carcass_round.")), "brass_armory.jei.carcass_round", PotionUtils.m_43549_((ItemStack)result.m_41777_(), (Potion)potion), newIngredients));
            }
            NonNullList newIngredients = NonNullList.m_122779_();
            boolean flag = false;
            for (Ingredient ingredient : ingredients) {
                if (ingredient.test(new ItemStack((ItemLike)Items.f_42739_))) {
                    newIngredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42735_}));
                    flag = true;
                    continue;
                }
                newIngredients.add((Object)ingredient);
            }
            if (!flag) continue;
            if (craftingRecipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)craftingRecipe;
                recipes.add((CraftingRecipe)new ShapedRecipe(BrassArmory.locate("dragon_round"), "brass_armory.jei.dragon_round", shapedRecipe.m_44220_(), shapedRecipe.m_44221_(), newIngredients, (ItemStack)Util.m_137469_((Object)result.m_41777_(), stack -> stack.m_41784_().m_128379_("BADragonRound", true))));
                continue;
            }
            if (!(craftingRecipe instanceof ShapelessRecipe)) continue;
            recipes.add((CraftingRecipe)new ShapelessRecipe(BrassArmory.locate("dragon_round"), "brass_armory.jei.dragon_round", (ItemStack)Util.m_137469_((Object)result.m_41777_(), stack -> stack.m_41784_().m_128379_("BADragonRound", true)), newIngredients));
        }
        return recipes;
    }

    @NotNull
    public static List<CraftingRecipe> regTorchArrows(RecipeManager recipeManager) {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (Recipe recipe : recipeManager.m_44051_()) {
            CraftingRecipe craftingRecipe;
            if (!(recipe instanceof CraftingRecipe) || !(craftingRecipe = (CraftingRecipe)recipe).m_8043_().m_150930_((Item)BrassArmoryItems.TORCH_ARROW.get()) || craftingRecipe.m_7527_().isEmpty()) continue;
            NonNullList ingredients = craftingRecipe.m_7527_();
            ItemStack result = craftingRecipe.m_8043_();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                StandingAndWallBlockItem torchItem;
                if (!(item instanceof StandingAndWallBlockItem) || !((torchItem = (StandingAndWallBlockItem)item).m_40614_() instanceof TorchBlock) || torchItem.equals(Items.f_42000_)) continue;
                NonNullList newIngredients = NonNullList.m_122779_();
                boolean flag = false;
                for (Ingredient ingredient : ingredients) {
                    if (ingredient.test(new ItemStack((ItemLike)Items.f_42000_))) {
                        newIngredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{torchItem}));
                        flag = true;
                        continue;
                    }
                    newIngredients.add((Object)ingredient);
                }
                if (!flag) continue;
                if (craftingRecipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)craftingRecipe;
                    recipes.add((CraftingRecipe)new ShapedRecipe(BrassArmory.locate("carcass_round." + torchItem), "brass_armory.jei.carcass_round", shapedRecipe.m_44220_(), shapedRecipe.m_44221_(), newIngredients, (ItemStack)Util.m_137469_((Object)result.m_41777_(), stack -> ArmoryUtil.addStack(stack.m_41784_(), torchItem.m_7968_(), "BATorch"))));
                    continue;
                }
                if (!(craftingRecipe instanceof ShapelessRecipe)) continue;
                recipes.add((CraftingRecipe)new ShapelessRecipe(BrassArmory.locate("carcass_round." + torchItem), "brass_armory.jei.carcass_round", (ItemStack)Util.m_137469_((Object)result.m_41777_(), stack -> ArmoryUtil.addStack(stack.m_41784_(), torchItem.m_7968_(), "BATorch")), newIngredients));
            }
        }
        return recipes;
    }
}

