/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.capabilities;

import com.milamber_brass.brass_armory.capabilities.IQuiverCapability;
import com.milamber_brass.brass_armory.item.QuiverItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class QuiverCapabilityHandler
implements IQuiverCapability {
    private Player player;
    private ItemStack ammoStack;
    private ItemStack quiverStack;

    @Override
    public void setEntity(Player player) {
        this.player = player;
    }

    @Override
    public void tick() {
        if (!this.getQuiverStack().m_41619_()) {
            if (this.player.m_150109_().f_35974_.contains((Object)this.quiverStack)) {
                Optional<ItemStack> inQuiverAmmoStack = QuiverItem.getContents(this.quiverStack).findFirst();
                if (inQuiverAmmoStack.isPresent() && (!ItemStack.m_150942_((ItemStack)inQuiverAmmoStack.get(), (ItemStack)this.getAmmoStack()) || inQuiverAmmoStack.get().m_41613_() != this.getAmmoStack().m_41613_())) {
                    QuiverItem.removeOne(this.quiverStack);
                    if (!this.getAmmoStack().m_41619_()) {
                        QuiverItem.add(this.quiverStack, this.ammoStack);
                    }
                    this.setQuiverStack(ItemStack.f_41583_);
                    this.setAmmoStack(ItemStack.f_41583_);
                }
            } else {
                this.setQuiverStack(ItemStack.f_41583_);
            }
        }
    }

    @Override
    @NotNull
    public ItemStack getAmmoStack() {
        return this.ammoStack != null ? this.ammoStack : ItemStack.f_41583_;
    }

    @Override
    public void setAmmoStack(ItemStack stack) {
        this.ammoStack = stack;
    }

    @Override
    @NotNull
    public ItemStack getQuiverStack() {
        return this.quiverStack != null ? this.quiverStack : ItemStack.f_41583_;
    }

    @Override
    public void setQuiverStack(ItemStack stack) {
        this.quiverStack = stack;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ArmoryUtil.addStack(tag, this.getAmmoStack(), "ammo");
        ArmoryUtil.addStack(tag, this.getQuiverStack(), "quiver");
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.setAmmoStack(ArmoryUtil.loadStack(tag, "ammo", ItemStack.f_41583_));
        this.setQuiverStack(ArmoryUtil.loadStack(tag, "quiver", ItemStack.f_41583_));
    }
}

