/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.client.render;

import com.milamber_brass.brass_armory.behaviour.GunBehaviours;
import com.milamber_brass.brass_armory.client.model.CannonModel;
import com.milamber_brass.brass_armory.entity.CannonEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class CannonEntityRenderer
extends EntityRenderer<CannonEntity> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("brass_armory", "textures/entity/cannon/cannon.png");
    private static final ResourceLocation[] RESOURCE_LOCATIONS = new ResourceLocation[]{new ResourceLocation("brass_armory", "textures/entity/cannon/0.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/1.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/2.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/3.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/4.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/5.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/6.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/7.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/8.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/9.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/10.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/11.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/12.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/13.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/14.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/15.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/16.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/17.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/18.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/19.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/20.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/21.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/22.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/23.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/24.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/25.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/26.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/27.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/28.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/29.png"), new ResourceLocation("brass_armory", "textures/entity/cannon/30.png")};
    private final CannonModel<CannonEntity> model;

    public CannonEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new CannonModel(context.m_174023_(BrassArmoryModels.CANNON_MODEL));
    }

    public void render(CannonEntity cannon, float yaw, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light) {
        stack.m_85836_();
        float yRot = Mth.m_14179_((float)partialTicks, (float)cannon.f_19859_, (float)cannon.m_146908_());
        float xRot = cannon.m_5686_(partialTicks);
        Entity entity = cannon.m_6688_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            yRot = living.m_5675_(partialTicks);
            xRot = Mth.m_14036_((float)living.m_5686_(partialTicks), (float)-45.0f, (float)15.0f);
            living.f_20883_ = living.m_146908_();
            living.f_20884_ = living.f_19859_;
        }
        stack.m_85836_();
        float f = (float)cannon.getHurtTime() - partialTicks;
        float f1 = cannon.getDamage() - partialTicks;
        if (f > 0.0f) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 200.0f * (float)cannon.getHurtDir()));
        }
        stack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        BlockPos pos = cannon.m_20183_();
        double offset = (double)(pos.m_123341_() % 2 + pos.m_123343_() % 2 * 2) * 3.0E-4;
        stack.m_85837_(offset, -1.5 + offset, offset);
        float z = this.model.cannon_end.f_104202_;
        int fuse = cannon.getFuse();
        this.model.setupAnim(cannon, yaw, fuse, partialTicks, yRot, xRot);
        if (fuse > 28 && GunBehaviours.getPowderBehaviour(cannon.getPowder()).isPresent()) {
            this.model.cannon_end.f_104202_ = z - Mth.m_14179_((float)partialTicks, (float)this.getCannonZOffset(fuse - 1), (float)this.getCannonZOffset(fuse));
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.model.m_103119_(this.getTextureLocation(cannon)));
        this.model.m_7695_(stack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (fuse <= 30) {
            VertexConsumer fuseConsumer = bufferSource.m_6299_(this.model.m_103119_(this.getTextureLocation(fuse)));
            this.model.m_7695_(stack, fuseConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        this.model.cannon_end.f_104202_ = z;
        stack.m_85849_();
        stack.m_85849_();
        super.m_7392_((Entity)cannon, yaw, partialTicks, stack, bufferSource, light);
    }

    private float getCannonZOffset(int i) {
        return switch (i) {
            case 30 -> 3.0f;
            case 31 -> 1.5f;
            default -> 0.0f;
        };
    }

    @NotNull
    public ResourceLocation getTextureLocation(CannonEntity cannon) {
        return RESOURCE_LOCATION;
    }

    @NotNull
    public ResourceLocation getTextureLocation(int fuse) {
        return RESOURCE_LOCATIONS[Mth.m_14045_((int)fuse, (int)0, (int)30)];
    }
}

