/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.client.render;

import com.milamber_brass.brass_armory.entity.projectile.FlailHeadEntity;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.item.FlailItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class FlailHeadEntityRenderer<T extends FlailHeadEntity>
extends EntityRenderer<T> {
    protected static final ResourceLocation IRON_LINK = new ResourceLocation("brass_armory", "textures/item/iron/iron_link.png");
    protected static final ResourceLocation NETHERITE_LINK = new ResourceLocation("brass_armory", "textures/item/netherite/netherite_link.png");
    protected static final ResourceLocation GOLD_LINK = new ResourceLocation("brass_armory", "textures/item/gold/golden_link.png");
    protected final ItemRenderer itemRenderer;

    public FlailHeadEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
        this.f_114477_ = 0.15f;
        this.f_114478_ = 0.75f;
    }

    public void render(T flailHead, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (((FlailHeadEntity)((Object)flailHead)).f_19797_ >= 2 || !(this.f_114476_.f_114358_.m_90592_().m_20280_(flailHead) < 12.25)) {
            poseStack.m_85836_();
            ItemStack stack = ((AbstractThrownWeaponEntity)((Object)flailHead)).m_7846_();
            Item item = stack.m_41720_();
            if (item instanceof FlailItem) {
                FlailItem flailItem = (FlailItem)item;
                stack = flailItem.getHead().m_7968_();
            }
            stack.m_41751_(((AbstractThrownWeaponEntity)((Object)flailHead)).m_7846_().m_41783_());
            poseStack.m_85837_(0.0, 0.1, 0.0);
            poseStack.m_85845_(this.f_114476_.m_114470_());
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            poseStack.m_85837_(0.0, -0.1, 0.0);
            BakedModel bakedmodel = this.itemRenderer.m_174264_(stack, ((FlailHeadEntity)((Object)flailHead)).f_19853_, null, flailHead.m_19879_());
            this.itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GROUND, false, poseStack, bufferSource, light, OverlayTexture.f_118083_, bakedmodel);
            poseStack.m_85849_();
            super.m_7392_(flailHead, yaw, partialTicks, poseStack, bufferSource, light);
            Entity entity = ((FlailHeadEntity)((Object)flailHead)).m_37282_();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                this.renderLinks(flailHead, partialTicks, poseStack, bufferSource, light, ((AbstractThrownWeaponEntity)((Object)flailHead)).m_7846_(), living);
            }
        }
    }

    private <E extends LivingEntity> void renderLinks(T flailHead, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, E owner) {
        Tiers tiers;
        float bonusY;
        double flailZ;
        double flailY;
        double flailX;
        int right;
        poseStack.m_85836_();
        int n = right = owner.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
        if (!(owner.m_21205_().m_41720_() instanceof FlailItem)) {
            right = -right;
        }
        float attackAnim = owner.m_21324_(partialTicks);
        float sin1 = Mth.m_14031_((float)(Mth.m_14116_((float)attackAnim) * (float)Math.PI));
        float v4 = Mth.m_14179_((float)partialTicks, (float)owner.f_20884_, (float)owner.f_20883_) * ((float)Math.PI / 180);
        double sin = Mth.m_14031_((float)v4);
        double cos = Mth.m_14089_((float)v4);
        double v = (double)right * 0.35;
        if (this.f_114476_.f_114360_.m_92176_().m_90612_() && owner == Minecraft.m_91087_().f_91074_) {
            double d7 = 960.0 / (double)((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).intValue();
            Vec3 pointOnPlane = this.f_114476_.f_114358_.m_167684_().m_167695_((float)right * 0.525f, -0.1f);
            pointOnPlane = pointOnPlane.m_82490_(d7);
            pointOnPlane = pointOnPlane.m_82524_(sin1 * 0.5f);
            pointOnPlane = pointOnPlane.m_82496_(-sin1 * 0.7f);
            flailX = Mth.m_14139_((double)partialTicks, (double)owner.f_19854_, (double)owner.m_20185_()) + pointOnPlane.f_82479_;
            flailY = Mth.m_14139_((double)partialTicks, (double)owner.f_19855_, (double)owner.m_20186_()) + pointOnPlane.f_82480_ + 0.25;
            flailZ = Mth.m_14139_((double)partialTicks, (double)owner.f_19856_, (double)owner.m_20189_()) + pointOnPlane.f_82481_;
            bonusY = owner.m_20192_();
        } else {
            flailX = Mth.m_14139_((double)partialTicks, (double)owner.f_19854_, (double)owner.m_20185_()) - cos * v - sin * 0.8;
            flailY = owner.f_19855_ + (double)owner.m_20192_() + (owner.m_20186_() - owner.f_19855_) * (double)partialTicks - 0.2;
            flailZ = Mth.m_14139_((double)partialTicks, (double)owner.f_19856_, (double)owner.m_20189_()) - sin * v + cos * 0.8;
            bonusY = owner.m_6047_() ? -0.1875f : 0.0f;
        }
        double headX = Mth.m_14139_((double)partialTicks, (double)((FlailHeadEntity)((Object)flailHead)).f_19854_, (double)flailHead.m_20185_());
        double headY = Mth.m_14139_((double)partialTicks, (double)((FlailHeadEntity)((Object)flailHead)).f_19855_, (double)flailHead.m_20186_());
        double headZ = Mth.m_14139_((double)partialTicks, (double)((FlailHeadEntity)((Object)flailHead)).f_19856_, (double)flailHead.m_20189_());
        float finalX = (float)(flailX - headX);
        float finalY = (float)(flailY - headY) + bonusY;
        float finalZ = (float)(flailZ - headZ);
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            tiers = tieredItem.m_43314_();
        } else {
            tiers = Tiers.IRON;
        }
        ResourceLocation linkLocation = this.getLinkTextureLocation((FlailHeadEntity)((Object)flailHead), (Tier)tiers);
        int maxR = flailHead.m_36797_() ? (int)Math.min((double)owner.m_20270_(flailHead) * 2.2, 11.0) : 11;
        for (int r = 0; r < maxR; ++r) {
            poseStack.m_85836_();
            Vec3 linkPos = new Vec3((double)finalX, (double)finalY, (double)finalZ).m_82490_(0.0636 * (double)r);
            poseStack.m_85837_(linkPos.f_82479_, linkPos.f_82480_ + (double)(maxR - r) * 0.008, linkPos.f_82481_);
            poseStack.m_85841_(0.08f, 0.08f, 0.08f);
            poseStack.m_85845_(this.f_114476_.m_114470_());
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            PoseStack.Pose pose = poseStack.m_85850_();
            Matrix4f matrix4f = pose.m_85861_();
            Matrix3f matrix3f = pose.m_85864_();
            VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)linkLocation));
            FlailHeadEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, 0.0f, 0, 0, 1);
            FlailHeadEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, 1.0f, 0, 1, 1);
            FlailHeadEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, 1.0f, 1, 1, 0);
            FlailHeadEntityRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, 0.0f, 1, 0, 0);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, int light, float v, int i, int j, int k) {
        vertexConsumer.m_85982_(matrix4f, v - 0.5f, (float)i - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)j, (float)k).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    @Nonnull
    public ResourceLocation getTextureLocation(FlailHeadEntity flailHead) {
        return IRON_LINK;
    }

    @Nonnull
    protected ResourceLocation getLinkTextureLocation(FlailHeadEntity flailHead, Tier tier) {
        if (Tiers.NETHERITE.equals((Object)tier)) {
            return NETHERITE_LINK;
        }
        if (Tiers.GOLD.equals((Object)tier) || Tiers.DIAMOND.equals((Object)tier)) {
            return GOLD_LINK;
        }
        return this.getTextureLocation(flailHead);
    }
}

