/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.abstracts;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public abstract class AbstractRollableItemProjectileEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Float> DATA_RENDER_ROTATION = SynchedEntityData.m_135353_(AbstractRollableItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_RENDER_ROTATION0 = SynchedEntityData.m_135353_(AbstractRollableItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float rotDirection;
    protected int hitPerTick;

    public AbstractRollableItemProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
        this.rotDirection = -10.0f;
    }

    public AbstractRollableItemProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, double x, double y, double z, Level level) {
        super(entityType, x, y, z, level);
        this.rotDirection = -10.0f;
    }

    public AbstractRollableItemProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity living, Level level, @Nullable HumanoidArm arm) {
        super(entityType, living, level);
        this.rotDirection = arm == HumanoidArm.LEFT ? 10.0f : -10.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_RENDER_ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_RENDER_ROTATION0, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        this.hitPerTick = 0;
        super.m_8119_();
        if (this.m_20096_()) {
            this.onGroundTick();
        } else if (!this.m_20068_()) {
            this.setRotation0(this.getRotation());
            this.setRotation(this.getRotation() + this.rotDirection * (float)this.m_20184_().m_82553_());
        }
    }

    protected void onGroundTick() {
        Vec3 vec = this.m_20184_();
        boolean flag = this.m_20229_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        vec = vec.m_82542_(0.9, flag ? 1.0 : 0.0, 0.9);
        float length = (float)vec.m_82553_();
        this.setRotation0(this.getRotation());
        if ((double)length > 0.01) {
            this.setRotation(this.getRotation() + this.rotDirection * length * (this.m_20072_() ? 2.0f : 8.0f));
        } else {
            vec.m_82490_(0.0);
        }
        this.m_20256_(vec);
        this.m_6853_(!flag);
    }

    @Nonnull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41619_()) {
            player.m_21008_(hand, this.m_7846_());
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6087_() {
        return true;
    }

    protected void m_6532_(HitResult hitResult) {
        switch (hitResult.m_6662_()) {
            case ENTITY: {
                this.m_5790_((EntityHitResult)hitResult);
                break;
            }
            case BLOCK: {
                this.m_8060_((BlockHitResult)hitResult);
                break;
            }
            default: {
                return;
            }
        }
        this.m_146852_(GameEvent.f_157777_, this.m_37282_());
        this.rotDirection -= (float)this.m_20184_().m_82553_() * 2.0f;
    }

    protected void onHitEffects() {
        float volume = (float)this.m_20184_().m_82553_() * this.getVolumeMultiplier();
        this.m_5496_(this.getSoundEvent(), volume, ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) / 0.8f);
    }

    protected abstract SoundEvent getSoundEvent();

    protected abstract float getVolumeMultiplier();

    @NotNull
    public Component m_7755_() {
        return this.m_7846_().m_41720_().m_7626_(this.m_7846_());
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        if (this.hitPerTick == 0) {
            this.onHitEffects();
        }
        if (++this.hitPerTick > 8) {
            this.m_6074_();
            return;
        }
        BlockPos pos = blockHitResult.m_82425_();
        BlockState blockState = this.f_19853_.m_8055_(pos);
        if (blockState.m_60734_() instanceof IronBarsBlock && blockState.m_60767_().equals(Material.f_76275_)) {
            this.f_19853_.m_46953_(pos, true, this.m_37282_());
            this.m_20256_(this.m_20184_().m_82490_(0.85));
            return;
        }
        super.m_8060_(blockHitResult);
        Direction.Axis axis = blockHitResult.m_82434_().m_122434_();
        Vec3 movement = AbstractRollableItemProjectileEntity.bounce(this.m_20184_(), axis, this.getBounceMultiplier());
        this.m_20256_(movement);
        HitResult newHitResult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (newHitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.m_6532_(newHitResult);
        } else if (movement.f_82480_ < 0.05 && blockHitResult.m_82434_() == Direction.UP) {
            this.m_6853_(true);
            this.m_20334_(movement.f_82479_, 0.0, movement.f_82481_);
        }
    }

    protected abstract double getBounceMultiplier();

    @Nonnull
    public static Vec3 bounce(Vec3 deltaMovement, Direction.Axis axis, double multiplier) {
        if (multiplier == 1.0) {
            return deltaMovement.m_82542_(axis.equals((Object)Direction.Axis.X) ? -1.0 : 1.0, axis.equals((Object)Direction.Axis.Y) ? -1.0 : 1.0, axis.equals((Object)Direction.Axis.Z) ? -1.0 : 1.0);
        }
        double newX = deltaMovement.f_82479_ * (axis.equals((Object)Direction.Axis.X) ? -multiplier : 0.75);
        double newY = deltaMovement.f_82480_ * (axis.equals((Object)Direction.Axis.Y) ? -multiplier : 0.75);
        double newZ = deltaMovement.f_82481_ * (axis.equals((Object)Direction.Axis.Z) ? -multiplier : 0.75);
        return new Vec3(newX, newY, newZ);
    }

    public void setRotation(float newRotation) {
        this.f_19804_.m_135381_(DATA_RENDER_ROTATION, (Object)Float.valueOf(newRotation));
    }

    public float getRotation() {
        return ((Float)this.f_19804_.m_135370_(DATA_RENDER_ROTATION)).floatValue();
    }

    public void setRotation0(float newRotation) {
        this.f_19804_.m_135381_(DATA_RENDER_ROTATION0, (Object)Float.valueOf(newRotation));
    }

    public float getRotation0() {
        return ((Float)this.f_19804_.m_135370_(DATA_RENDER_ROTATION0)).floatValue();
    }

    public void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128350_("BARollableRotation", this.getRotation());
        super.m_7380_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setRotation(compoundTag.m_128457_("BARollableRotation"));
        this.setRotation0(this.getRotation());
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

