/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.arrow;

import com.milamber_brass.brass_armory.client.render.SpecialArrowRenderer;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractSpecialArrowEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.SpecialArrowItem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class DirtArrowEntity
extends AbstractSpecialArrowEntity {
    public DirtArrowEntity(EntityType<? extends DirtArrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public DirtArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.DIRT_ARROW.get()), level, shooter);
        this.m_36781_(0.25);
        if (shooter instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
    }

    public DirtArrowEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.DIRT_ARROW.get()), level, x, y, z);
        this.m_36781_(0.25);
        this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        if (!this.dealtDamage) {
            this.f_19853_.m_46597_(this.m_20183_(), Blocks.f_50493_.m_49966_());
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos relative;
        super.m_8060_(result);
        if (!this.dealtDamage && this.f_19853_.m_8055_(relative = result.m_82425_().m_121945_(result.m_82434_())).m_60767_().m_76336_()) {
            this.f_19853_.m_7731_(relative, Blocks.f_50493_.m_49966_(), 2);
            this.f_19853_.m_142346_(this.m_37282_(), GameEvent.f_157797_, relative);
            this.m_146870_();
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ((SpecialArrowItem)((Object)BrassArmoryItems.DIRT_ARROW.get())).m_7968_();
    }

    @Override
    protected void spawnArrowParticles(int particleCount) {
        for (int j = 0; j < particleCount; ++j) {
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_()), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 40.0, 75.0, 40.0);
        }
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return SpecialArrowRenderer.DIRT_ARROW_TEXTURE;
    }
}

